#include <glib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <pthread.h>

#include <asdutil.h>

#include "unix.h"
#include "asdlib.h"
#include "asderrno.h"

int unix_try_connect(gchar *fname)
{
  int fd;
  struct sockaddr_un name;
  char p[PATH_MAX];

  asd_set_errno(PROTOCOL_ASD_ERROR_SUCCESS);

  if (!fname)
    {
      g_snprintf(p, sizeof(p), "%s/.asd-socket", g_get_home_dir());
      fname = p;
    }
  
  if ((fd = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0)
    {
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return -1;
    }

  pthread_cleanup_push(fd_cleanup_handler, &fd);
  
  name.sun_family = AF_LOCAL;
  strncpy(name.sun_path, fname, sizeof(name.sun_path));

  if (connect(fd, (struct sockaddr *) &name, SUN_LEN(&name)) < 0)
    {
      close(fd);
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return -1;
    }

  pthread_cleanup_pop(0);

  return fd;
}

