------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--                         A S I S _ U L . M I S C                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2006, AdaCore                        --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not, write to the Free Software Foundation, 59 Temple Place  --
--  - Suite 330, Boston,                                                    --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains various useful resources for which we can not find
--  at the moment a specific ASIS Utility Library package to place into

package ASIS_UL.Misc is

   -----------------------
   -- String Hash table --
   -----------------------

   --  This is a slight modification from the Hash function from the GNAT Namet
   --  package. The way of computing the hash values is exactly the same as
   --  used in Namet.Hash, but we have changed the interface. There are three
   --  modifications. First, the original GNAT Hash finction does not have a
   --  formal parameter and operates on an internal string buffer, but here we
   --  have added a parameter. Second - our hash function is not
   --  case-sensitive. And third, we use a wrapper generic package to give the
   --  clients the possibility to use hash tables for different string entry
   --  IDs types

   generic
      type Entry_Id is (<>);
   package String_Hash_Table is

      type Int is range -2 ** 31 .. +2 ** 31 - 1;

      Hash_Num : constant Int := 2**12;
      --  Number of headers in the hash table. Current hash algorithm is
      --  closely tailored to this choice, so it can only be changed if a
      --  corresponding change is made to the hash algorithm.

      Hash_Max : constant Int := Hash_Num - 1;
      --  Indexes in the hash header table run from 0 to Hash_Num - 1

      subtype Hash_Index_Type is Int range 0 .. Hash_Max;
      --  Range of hash index values

      Hash_Table : array (Hash_Index_Type) of Entry_Id;
      --  The hash table is used to locate existing entries in the strings
      --  table. The entries point to the first strings table entry whose hash
      --  value matches the hash code. Then subsequent string table entries
      --  with the same hash code value should be linked, and this link chould
      --  be used for locating the needed entry

      function Hash (Name : String) return Hash_Index_Type;
      --  Compute hash code for its argument

   end String_Hash_Table;

   -------------------
   -- Miscellaneous --
   -------------------

   function Is_White_Space (Ch : Character) return Boolean;
   --  Checks if the argumet is either a space or HT character

   function Image (I : Integer) return String;
   --  Returns the string image of I, with no leading or trailing spaces

   function Is_Identifier (S : String) return Boolean;
   --  Checks if S has a syntax of an Ada identifier

   function Is_Identifier_Suffix (Suffix : String) return Boolean;
   --  Checks if the Suffix string can be a suffix af a valid Ada identifier.

end ASIS_UL.Misc;
