------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
-- A S I S _ U L . E N V I R O N M E N T . C H E C K  _ P A R A M E T E R S --
--                                                                          --
--            (adapted for gnatcheck from ASIS Utility Library)             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2005-2008, AdaCore                     --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Options;            use ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;       use ASIS_UL.Source_Table;

with Gnatcheck.Compiler;         use Gnatcheck.Compiler;
with Gnatcheck.Options;
with Gnatcheck.Output;           use Gnatcheck.Output;
with Gnatcheck.Rules;            use Gnatcheck.Rules;
with Gnatcheck.Rules.Rule_Table; use Gnatcheck.Rules.Rule_Table;

separate (ASIS_UL.Environment)
procedure Check_Parameters is
begin

   Set_Compiler_Checks;

   if Use_gnaty_Option then
      if not Use_gnatw_Option then
         --  We have to neutralize the default 'gnatws' used in the compiler
         --  call that creates the tree, but we do not want to turn any
         --  warning on. So we use the default gnatcheck setting for warning
         --  options: -gnatwn and disabling all warnings that can be disabled
         --  with -gnatw* option.

         Store_Option (Get_Warning_Option);

         --  We do not store warning options using dot notation in this case -
         --  all of them should be OFF

         Store_Option ("-gnatwn");

      end if;

      --  Get rid of all the style options that can come from a project
      --  file:
      Store_Option ("-gnatyN");

      Store_Option (Get_Style_Option);
   end if;

   if Use_gnatw_Option then

      if not Use_gnaty_Option then
         Store_Option ("-gnatyN");
      end if;

      Store_Option (Get_Warning_Option);

      Reset_Dot_Warning_Opt_Iterator;

      while not Done loop
         Store_Option (Next_Dot_Warning_Option);
      end loop;

      Store_Option ("-gnatwn");
   end if;

   if Check_Restrictions then

      if not Use_gnaty_Option then
         Store_Option ("-gnatyN");
      end if;

      if not Use_gnatw_Option then
         --  We have to neutralize the default 'gnatws' used in the compiler
         --  call that creates the tree, but we do not want to turn any
         --  warning on. So we use the default gnatcheck setting for warning
         --  options: -gnatwn and disabling all warnings that can be disabled
         --  with -gnatw* option.

         Store_Option (Get_Warning_Option);

         --  We do not store warning options using dot notation in this case -
         --  all of them should be OFF

         Store_Option ("-gnatwn");
      end if;

      Store_Option ("-gnatec=" & Restriction_Config_File);
   end if;

   Suppess_Compiler_Check := not (Use_gnatw_Option
                                or else
                                  Use_gnaty_Option
                                or else
                                  Check_Restrictions);

   Process_ADA_PRJ_INCLUDE_FILE;

   Set_Arg_List;

   Nothing_To_Do := Last_Source < First_SF_Id;

   if Nothing_To_Do then

      if not Gnatcheck.Options.Generate_Rules_Help then
         Error ("No input source file set");
         Brief_Help;
         raise Parameter_Error;
      end if;
   else
      Total_Sources := Natural (Last_Source);
      Sources_Left  := Total_Sources;

      --  Check is the active set of rules requires building the global
      --  structure

      for J in First_Rule .. All_Rules.Last loop

         if All_Rules.Table (J).Rule_State = Enabled
           and then
            All_Rules.Table (J).all in Global_Rule_Template'Class
         then
            ASIS_UL.Options.Buld_Call_Graph := True;
            exit;
         end if;

      end loop;

      ASIS_UL.Output.Set_Report_File;
   end if;

end Check_Parameters;
