------------------------------------------------------------------------------
--                                                                          --
--                      DISPLAY_SOURCE COMPONENTS                           --
--                                                                          --
--                           N O D E _ T R A V                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- Display_Source is free software; you can redistribute it and/or modify it--
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Display_Source is distributed in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Display_Source is distributed as a part of the ASIS implementation for   --
-- GNAT (ASIS-for-GNAT).                                                     --
--                                                                          --
-- The   original   version   of  Display_Source  has  been  developed  by  --
-- Jean-Charles  Marteau and Serge Reboul,  ENSIMAG  High School Graduates  --
-- (Computer sciences)  Grenoble,  France  in  Sema Group Grenoble, France. --
--                                                                          --
-- Display_Source is now maintained by Ada Core Technologies Inc            --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

-----------------------------------------------------------------
-- This package is part of the ASIS application display_source --
-----------------------------------------------------------------
-- It contains procedures to instantiate Traverse_Element with --
-- in order to display the node Kinds of the traversed elements--
-- It works with several modes and let the user choose if he   --
-- want to display lines numbers or so ..                      --
-- It can be used to test Control Behaviour too ...            --
-----------------------------------------------------------------
with Asis;

package Node_Trav is

   type Info_Node is
      record
         Last_Commented_Line : Natural := 0;
         Indentation : Natural := 0;
      end record;

   -------------------------------------------
   --                                       --
   --  Here are the 2 procedures that are   --
   --  called in pre_procedure when we are  --
   --  in test_control mode.                --
   --                                       --
   -------------------------------------------

   procedure Pre_Test_Control
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Node);

   procedure Post_Test_Control
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Node);

   --------------------------------------------
   --                                        --
   --  Here is the pre procedure to provide  --
   --  to Traverse_Element to make a node    --
   --  display.                              --
   --                                        --
   --------------------------------------------

   procedure Pre_Procedure
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Node);

   procedure Post_Procedure
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Node);

   procedure Initiate_Node
     (Unit : in     Asis.Compilation_Unit;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Node);

   procedure Terminate_Node
     (Control : in out Asis.Traverse_Control;
      State   : in out Info_Node);

end Node_Trav;