------------------------------------------------------------------------------
--                                                                          --
--                            GNATELIM COMPONENTS                           --
--                                                                          --
--                 G N A T E L I M . P R O C E S S _ B I N D _ F I L E      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.9 $
--                                                                          --
--            Copyright (c) 1997-2001, Free Software Foundation, Inc.       --
--                                                                          --
-- Gnatelim is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnatelim is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Gnatelim is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT).                                                         --
--                                                                          --
-- Gnatelim was originally developed by Alain Le Guennec                    --
--                                                                          --
-- Gnatelim  is  now  maintained  by  Ada  Core  Technologies  Inc          --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

with Asis; use Asis;
package GNATELIM.Process_Bind_File is

   function Get_Units_From_Bind_File
     (C : Context; Main, Bindname : String)
     return Compilation_Unit_List;
   --  Taking the name of the main unit, this procedure tries to return
   --  the full list of the Compilation Units upon which the given unit depends
   --  semantically. It uses the Ada or C bind file created for the main unit
   --  to do this, therefore units are returned in the right elaboration order.
   --  If there is no bind file, or if for some unit name retrieved from the
   --  bind file the corresponding ASIS Compilation Unit is nil, Fatal_Error
   --  is raised. If Bindname is not empty, it is used as a name of the bind
   --  file< otherwise gnatelim will attempt to construct the bind file name
   --  from the main unit name; in the later case, if both Ada and C bind
   --  files are present, Ada bind file is processed

end GNATELIM.Process_Bind_File;
