------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                          A 4 G . G N A T _ I N T                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.9 $
--                                                                          --
--            Copyright (c) 1995-2001, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

with A4G.Vcheck;   use A4G.Vcheck;
with A4G.Contt;    use A4G.Contt;

with Output;       use Output;
with Types;        use Types;

package body A4G.GNAT_Int is

   LT : String renames ASIS_Line_Terminator;

   -------------
   -- Compile --
   -------------

   procedure Compile (Source_File : in  String_Access;
                      Args        : in  Argument_List;
                      Success     : out Boolean) is
      Comp_Args : Argument_List (Args'First .. Args'Last + 3 + 2 + 3);
      Comp_Last : Integer := Args'Last + 1 + 3;
      --  "+ 3" added in the modified version for the two GNAT flags
      --  ("-gnatc", "-gnatt" and "-gnatws")
      --  "+ 2" added for "-x ada"

   begin

      Comp_Args (Args'First)     := Comp_Flag;    -- "-c"     for gcc
      Comp_Args (Args'First + 1) := GNAT_Flag_c;  -- "-gnatc" for GNAT
      Comp_Args (Args'First + 2) := GNAT_Flag_t;  -- "-gnatt" for GNAT
      Comp_Args (Args'First + 3) := GNAT_Flag_ws; -- "-gnatws" for GNAT

      Comp_Args (Args'First + 1 + 3 .. Comp_Last) := Args;

      Comp_Last := Comp_Last + 1;

      Comp_Args (Comp_Last) := GCC_Flag_X;

      Comp_Last := Comp_Last + 1;

      Comp_Args (Comp_Last) := GCC_Par_Ada;

      Comp_Last := Comp_Last + 1;

      Comp_Args (Comp_Last) := Source_File;

      Success := Execute (Gcc, Comp_Args (Args'First .. Comp_Last));
   end Compile;

   -----------------
   -- Create_Tree --
   -----------------

   procedure Create_Tree (Source_File   : in  String_Access;
                          Context       : in  Context_Id;
                          Is_Predefined : in  Boolean;
                          Success       : out Boolean)
   is
   begin
      if Is_Predefined then
         Compile (Source_File => Source_File,
                  Args        => (1 => GNAT_Flag),
                  Success     => Success);
      else
         Compile (Source_File => Source_File,
                  Args        => I_Options (Context),
                  Success     => Success);
      end if;
   exception
      when others =>
         Raise_ASIS_Failed ("A4G.GNAT_Int.Create_Tree:" & LT &
                         "  check the path and environment settings for gcc!");
   end Create_Tree;

   -------------
   -- Execute --
   -------------

   function Execute (Program : String; Args : Argument_List) return Boolean is
      Success : Boolean;

      Execute : constant String_Access :=
        GNAT.OS_Lib.Locate_Exec_On_Path (Program);

   begin
      if Display_Executed_Programs then
         Write_Str (Program);

         for J in Args'Range loop
            Write_Str (" ");
            Write_Str (Args (J).all);
         end loop;

         Write_Eol;
      end if;

      GNAT.OS_Lib.Spawn (Execute.all, Args, Success);

      return Success;
   end Execute;
   --
   --  The code has simply been stolen from make.adb.

   ----------------------------------------------
   -- General Interfaces between GNAT and ASIS --
   ----------------------------------------------

   function A_Time (T : Time_Stamp_Type) return Time is
      Year      : Year_Number;
      Month     : Month_Number;
      Day       : Day_Number;
      Hours     : Integer range 0 .. 23;
      Minutes   : Integer range 0 .. 59;
      Seconds   : Integer range 0 .. 59;
      Day_Time  : Day_Duration;
   begin
      Split_Time_Stamp
        (TS      => T,
         Year    => Nat (Year),
         Month   => Nat (Month),
         Day     => Nat (Day),
         Hour    => Nat (Hours),
         Minutes => Nat (Minutes),
         Seconds => Nat (Seconds));

      Day_Time := Duration (Seconds + 60 * Minutes + 3600 * Hours);

      return Time_Of (Year, Month, Day, Day_Time);

   exception
      when others => return Time_Of (1901, 1, 1);
   end A_Time;

end A4G.GNAT_Int;
