// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "MemberProtections.h"

#include "Puma/ACTree.h"

MemberProtections::MemberProtections (ErrorSink &_err, ManipCommander &c) :
  _commander (c) {
  pubunit = new ACUnit(_err);
  *pubunit << endl << "public:" << endu;
  _commander.addBuffer(pubunit);
}

void MemberProtections::WeakentoPublic (CTree *node) {
  if (!(node->NodeName () == CT_ClassDef::NodeId ()))
     return;

  // remove all access specifiers from the member list
  CT_MembList *members = ((CT_ClassDef*)node)->Members ();
  for (int i = 0; i < members->Entries (); i++)
    if (members->Entry (i)->NodeName () == CT_AccessSpec::NodeId ()) {
      CTree* ct = members->Entry(i);
      if ( !ct->token()->is_macro_generated() &&
	   !ct->end_token()->is_macro_generated() ) {
	_commander.paste_before (ct->token (), pubunit);
	_commander.kill (ct);
      }
    }

  // paste "public:" after "class ... {"
  Token* tok = ((CT_ClassDef*)node)->Members ()->token ();
  if ( !tok->is_macro_generated() )
	_commander.paste (tok, pubunit);
}
