#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CCOverloading_h__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CCOverloading_h__
#define __CCOverloading_h__

#include "Puma/Array.h"
#include "Puma/ErrorSink.h"
#include "Puma/CCConversions.h"
#include "Puma/CCandidateInfo.h"

namespace Puma {


class CRecord;
class CTypeList;
class CFunctionInfo;
class CCNameLookup;
class CTypeFunction;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CCOverloading {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CCandidateInfo*> _Candidates;
  CTree *_Arguments; // ordinary function argument list
  CTree *_Arg0;      // operator arguments
  CTree *_Arg1;
  CTree *_Arg2;
  CTree *_Base;
  CTree *_Poi;
  unsigned _NumArgs;
  
  ErrorSink &err;
  bool user_def;     // user-defined conversions allowed
  bool operator_ovl; // operator overloading
  bool dependent;    // dependent call
 
  CCConversions cvs; // implicit conversions

  CTypeInfo *obj_type;

public:
  // usage: (error stream, is_operator_overloading)
  CCOverloading (ErrorSink &, bool = false);
  
  // set qualifiers
  void ObjectType (CTypeInfo *);
  void PointOfInst (CTree *);

  // usage: resolve(argument(s), allow_user_defined_conversions)
  void resolve (CTree *, bool = true);
  void resolve (CTree *, CTree *, bool = true);
  void resolve (CTree *, CTree *, CTree *, bool = true);
  void resolveMember (CTree *, CTree *);

  // the resulting function to call
  CFunctionInfo *Function () const;
  bool isAmbiguous () const;
  bool isDependent () const;

  unsigned Candidates () const;
  CCandidateInfo *Candidate (unsigned) const;
  void addCandidate (CCandidateInfo *);
  void removeCandidate (unsigned);

  void collectConvFunctions (CRecord *);
  void collectConstructors (CRecord *);
  void addCandidates (CCNameLookup &);
  
  // create built-in operators used as candidates for 
  // operator overloading, operator overloading mode
  // must be enabled (else nothing is done)
  void createBuiltinOperators (const char *, int, CTree *, CTree *);

  unsigned Arguments () const;
  CTree *Argument (unsigned) const;

private: // built-in operators
  void createIncrOp (const char *, CTypeInfo *, CTypeInfo *);
  void createDecrOp (const char *, CTypeInfo *, CTypeInfo *);
  void createMulOp (const char *, CTypeInfo *, CTypeInfo *);
  void createPlusOp (const char *, CTypeInfo *, CTypeInfo *);
  void createMinusOp (const char *, CTypeInfo *, CTypeInfo *);
  void createTildeOp (const char *, CTypeInfo *, CTypeInfo *);
  void createMembPtrOp (const char *, CTypeInfo *, CTypeInfo *);
  void createIndexOp (const char *, CTypeInfo *, CTypeInfo *);
  void createIfThenOp (const char *, CTypeInfo *, CTypeInfo *);
  void createLogOp (const char *, CTypeInfo *, CTypeInfo *);
  void createRelOp (const char *, CTypeInfo *, CTypeInfo *);
  void createBinOp (const char *, CTypeInfo *, CTypeInfo *);
  void createEqAssOp (const char *, CTypeInfo *, CTypeInfo *);
  void createAssOp (const char *, CTypeInfo *, CTypeInfo *);
  void createDivOp (const char *, CTypeInfo *, CTypeInfo *);
  void createEqOp (const char *, CTypeInfo *, CTypeInfo *);
  void createMulAssOp (const char *, CTypeInfo *, CTypeInfo *);
  void createAddAssOp (const char *, CTypeInfo *, CTypeInfo *);

private:
  void chooseViableFcts ();
  void chooseBestViableFct ();
  int compareCandidates (CCandidateInfo *, CCandidateInfo *) const;

  bool equalOrMoreQualified (CTypeFunction *, CTypeInfo *) const;
  bool moreSpecialized (CFunctionInfo *, CFunctionInfo *) const;
  bool hasDefaultArgument (CFunctionInfo *, CTypeList *, unsigned) const;
  void collectConvFunctions (CRecord *, unsigned);
  void collectConvTypes (CRecord *, Array<CTypeInfo*> &);
  CCStandardConvSeq *implicitThisConv (CTypeInfo *, CTypeInfo *, 
                                       CFunctionInfo *) const;
  
  void createParameter (CFunctionInfo *, CTypeInfo *) const;
  void createOperator (const char *, CTypeInfo *, CTypeInfo *, 
                       CTypeInfo * = 0);
};

inline CCOverloading::CCOverloading (ErrorSink &e, bool oovl) : 
  _Arguments (0),
  _Arg0 (0),
  _Arg1 (0),
  _Arg2 (0),
  _Poi (0),
  _NumArgs (0),
  err (e), 
  user_def (true), 
  operator_ovl (oovl),
  dependent (false),
  cvs (e),
  obj_type (0)
 {}

inline CFunctionInfo *CCOverloading::Function () const
 { return Candidates () ? Candidate (0)->Function () : (CFunctionInfo*)0; }
inline unsigned CCOverloading::Arguments () const 
 { return _NumArgs; }

inline bool CCOverloading::isAmbiguous () const
 { return (Candidates () > 1); }
inline bool CCOverloading::isDependent () const 
 { return dependent; }

inline unsigned CCOverloading::Candidates () const
 { return (unsigned)_Candidates.length (); }
inline CCandidateInfo *CCOverloading::Candidate (unsigned c) const
 { return _Candidates.lookup (c); }
inline void CCOverloading::removeCandidate (unsigned c)
 { _Candidates.remove (c); }


} // namespace Puma

#endif /* __CCOverloading_h__ */

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CCOverloading_h__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#include "WinIfExists.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#include "WinImportHandler.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#include "WinMacros.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#include "ExtACKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#include "PragmaOnceUnitState.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#include "PragmaOnce.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CCOverloading_h__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CCOverloading_h__
