# include "scanner.h"
# include "symbol.h"
# include "charbuffer.h"
# include "recognizer.h"
# include <string.h>
# include <ctype.h>
# include "normal_scantab.h"
# include "comment_scantab.h"


// Globals: A character buffer and token recognizers for normal and comment
// tokens

CharBuffer charbuffer;

Recognizer normal_recognizer (NormalMap, NormalStart, NormalStates, 
			      NormalNext, NormalControl, 
			      sizeof (NormalNext) / sizeof (int),
			      &charbuffer);

Recognizer comment_recognizer (CommentMap, CommentStart, CommentStates, 
			       CommentNext, CommentControl, 
			       sizeof (CommentNext) / sizeof (int),
			       &charbuffer);


// functions


int BeginScanning (char *FileName)
 {
   return charbuffer.BeginScanning (FileName);
 }


int EndScanning (void)
 {
   return charbuffer.EndScanning ();
 }


void NextToken (Token *Token)
 {
   int  Expression;
   int  Mode;
   long TokenRow, TokenColumn;
   int  Continue;
   int  CommentLevel;
   int  CommentMode;
   int  expr;
   int  len;
   int  result;

   Recognizer *ModeRecognizer;

   enum { NORMAL_MODE, COMMENT_MODE };
   enum { COMMENT_OPEN, COMMENT_CLOSE, NEW_LINE, COMMENT_TEXT };
   enum { LINE, NESTED };

   Mode = NORMAL_MODE;
   do
    { TokenRow    = charbuffer.row ();
      TokenColumn = charbuffer.column ();
      charbuffer.reset ();

      ModeRecognizer = (Mode == NORMAL_MODE) ? 
	&normal_recognizer : &comment_recognizer;

      result = ModeRecognizer->recognize (expr, len);

      if (result == -1)
       { // error
	 Token->Type = ERROR;
	 Token->Index = InsertSymbol (NULL, 0, TokenRow, TokenColumn);
	 return;
       }
      else if (result == 0)
       { // end of file
	 Token->Type = END;
	 return;
       }

      if (Mode == NORMAL_MODE)
       { switch (expr)
	  { case SPACE               : Continue     = 1;
	                               break;
	    case COMMENT             : Continue     = 1;
	                               Mode         = COMMENT_MODE;
	                               CommentLevel = 1;
	                               CommentMode  = NESTED;
	                               break;
	    case END_OF_LINE_COMMENT : Continue     = 1;
	                               Mode         = COMMENT_MODE;
	                               CommentLevel = 1;
	                               CommentMode  = LINE;
	                               break;
	    default                  : Continue     = 0;
	                               break;
	  }
       }
      else
       { Continue = 1;
	 switch (expr)
	  { case COMMENT_OPEN  : if (CommentMode == NESTED)
	                            CommentLevel++;
	                         break;
	    case COMMENT_CLOSE : if (CommentMode == NESTED)
                                  { CommentLevel--;
				    if (CommentLevel == 0)
				       Mode = NORMAL_MODE;
				  }
	                         break;
	    case NEW_LINE      : if (CommentMode == LINE)
	                            Mode = NORMAL_MODE;
	                         break;
	    case COMMENT_TEXT  : break;
	  }
       }
    } while (Continue);

   Token->Type = (TokenType)expr;
   if (expr == STRING || expr == CHAR)
    { charbuffer.token ()[len - 1] = '\0';
      Token->Index = InsertSymbol ((unsigned char *)(charbuffer.token () + 1),
				   len - 2, 
				   TokenRow, TokenColumn);
    }
   else if (expr == NAME)
    { charbuffer.token ()[len] = '\0';
      Token->Index = InsertSymbol ((unsigned char *)charbuffer.token (),
				   len, TokenRow, TokenColumn);
    }
   else
      Token->Index = InsertSymbol (NULL, 0, TokenRow, TokenColumn);

 }
   
