// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_info_h__
#define __location_info_h__

#include "Puma/RefCnt.h"
#include "Puma/Filename.h"

namespace Puma {


class LocationInfo : public RefCnt {
  Filename _filename;
  int _line;

public:
  LocationInfo () : _filename (), _line (0) {}
  void setup (Filename f, int l);
  const Filename &filename () const { return _filename; }
  int line () const { return _line; }
  bool operator < (const LocationInfo &l) const;
  bool operator == (const LocationInfo &l) const;
};


} // namespace Puma

#endif /* __location_info_h__ */
