// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __AdviceInfo_h__
#define __AdviceInfo_h__

#include <iostream>
using namespace std;

#include "PointCut.h"
#include "Binding.h"
#include "JoinPointLoc.h"
#include "BackEndProblems.h"
using namespace Puma;

class AspectInfo;
class BackEndProblems;

class AdviceInfo {
 
  AspectInfo &_aspect_info;
  JPL_Aspect &_aspect;
  PointCut _pointcut;
  Binding _binding;
  JPL_AdviceCode &_code;

public:
  AdviceInfo (AspectInfo &ai, JPL_AdviceCode &c);
  JPL_Aspect &aspect () const { return _aspect; }
  AspectInfo &aspect_info () const { return _aspect_info; }
  PointCut &pointcut () { return _pointcut; }
  Binding &binding () { return _binding; }
  
  JPL_AdviceCode &code () const { return _code; }

  void gen_invocation_func (ostream &out, bool def, const BackEndProblems &bep);
  void gen_invocation_func_call (ostream &stmt, const char* tjp_tp,
                                 const char *tjp_obj);

  void gen_binding_template (ostream &out, const char *jpname,
                             const BackEndProblems &bep);
  
  CScopeInfo *Scope () { return TI_AdviceCode::of (_code)->Scope (); }
  const char *name () { return TI_AdviceCode::of (_code)->name (); }
  JPL_AdviceCode::advice_type type () { return _code.type (); }
};

#endif // __AdviceInfo_h__
