// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/CObjectInfo.h"
#include "Puma/CScopeInfo.h"
#include "Puma/CTypeInfo.h"
#include "Puma/CFileInfo.h"
#include "Puma/CClassInfo.h"
#include "Puma/CUnionInfo.h"
#include "Puma/CEnumInfo.h"
#include "Puma/CLabelInfo.h"
#include "Puma/CLocalScope.h"
#include "Puma/CTypedefInfo.h"
#include "Puma/CEnumInfo.h"
#include "Puma/CEnumeratorInfo.h"
#include "Puma/CAttributeInfo.h"
#include "Puma/CArgumentInfo.h"
#include "Puma/CFunctionInfo.h"
#include "Puma/CTemplateInfo.h"
#include "Puma/CClassInstance.h"
#include "Puma/CFctInstance.h"
#include "Puma/CUnionInstance.h"
#include "Puma/CTemplateParamInfo.h"
#include "Puma/CMemberAliasInfo.h"
#include "Puma/CBaseClassInfo.h"
#include "Puma/CUsingInfo.h"
#include "Puma/CNamespaceInfo.h"
#include "Puma/Array.h"
#include "Puma/StrCol.h"
#include <sstream>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
using namespace std;

namespace Puma {


CObjectInfo::~CObjectInfo () { 
}

void CObjectInfo::CleanUp () {
  // cleanup symbol table
  if (Name ().empty() == false)
    for (unsigned i = _Registered.length (); i > 0; i--)
      _Registered.lookup (i-1)->removeObjectName (Name (), this);

  // remove from qualified scope
  if (QualifiedScope ()) {
    QualifiedScope ()->removeObject (this);
  }
  // remove from assigned scope
  if (AssignedScope ()) {
    AssignedScope ()->removeObject (this);
  }
  
  // cleanup template instance
  if (TemplateInstance () && TemplateInstance ()->Template ()) {
    TemplateInstance ()->Template ()->removeInstance (this);
  }
  // cleanup CArgumentInfo
  if (ArgumentInfo ()) {
    if (ArgumentInfo ()->Scope () && ArgumentInfo ()->Scope ()->FunctionInfo ())
      ArgumentInfo ()->Scope ()->FunctionInfo ()->removeArgument (ArgumentInfo ());
  }
  // cleanup CAttributeInfo
  if (AttributeInfo ()) {
    if (AttributeInfo ()->Scope () && AttributeInfo ()->Scope ()->Structure ())
      AttributeInfo ()->Scope ()->Structure ()->removeAttribute (AttributeInfo ());
    if (AttributeInfo ()->TemplateInfo ())
      AttributeInfo ()->TemplateInfo ()->ObjectInfo ((CObjectInfo*)0);
  }
  // cleanup CBaseClassInfo
  if (BaseClassInfo ()) {
    if (BaseClassInfo ()->Scope () && BaseClassInfo ()->Scope ()->ClassInfo ()) {
      CClassInfo *cinfo = BaseClassInfo ()->Scope ()->ClassInfo ();
      if (BaseClassInfo ()->Class ())
        BaseClassInfo ()->Class ()->removeDerivedClass (cinfo);
      cinfo->removeBaseClass (BaseClassInfo ());
    }
  }
  // cleanup CClassInfo
  if (ClassInfo ()) {
    for (unsigned i = 0; i < ClassInfo ()->BaseClasses (); i++) {
      CBaseClassInfo *info = ClassInfo ()->BaseClass (i);
      info->Class ()->removeDerivedClass (ClassInfo ());
      info->Scope ((CScopeInfo*)0);
      if (! _DeleteMembersOnly)
        delete info;
    }
    for (unsigned i = 0; i < ClassInfo ()->DerivedClasses (); i++)
      ClassInfo ()->DerivedClass (i)->removeBaseClass (ClassInfo ());
  }
  // cleanup CEnumInfo
  if (EnumInfo ()) {
    for (unsigned i = 0; i < EnumInfo ()->Enumerators (); i++) {
      EnumInfo ()->Enumerator (i)->Enum ((CEnumInfo*)0);
      if (! _DeleteMembersOnly)
        delete EnumInfo ()->Enumerator (i);
    }
    if (EnumInfo ()->Scope () && EnumInfo ()->Scope ()->Structure ())
      EnumInfo ()->Scope ()->Structure ()->removeType (EnumInfo ());
  }
  // cleanup CEnumeratorInfo
  if (EnumeratorInfo ()) {
    if (EnumeratorInfo ()->Enum ())
      EnumeratorInfo ()->Enum ()->removeEnumerator (EnumeratorInfo ());
  }
  // cleanup CFunctionInfo
  if (FunctionInfo ()) {
    for (unsigned i = 0; i < FunctionInfo ()->Labels (); i++) {
      FunctionInfo ()->Label (i)->Scope ((CScopeInfo*)0);
      if (! _DeleteMembersOnly)
        delete FunctionInfo ()->Label (i);
    }
    CScopeInfo *parent = FunctionInfo ()->Parent ();
    if (parent && parent->Structure ())
      parent->Structure ()->removeFunction (FunctionInfo ());
    if (FunctionInfo ()->AssignedScope ())
      FunctionInfo ()->AssignedScope ()->removeFunction (FunctionInfo ());
    if (FunctionInfo ()->TemplateInfo ())
      FunctionInfo ()->TemplateInfo ()->ObjectInfo ((CObjectInfo*)0);
  }
  // cleanup CLabelInfo
  if (LabelInfo ()) {
    if (LabelInfo ()->Scope () && LabelInfo ()->Scope ()->FunctionInfo ())
      LabelInfo ()->Scope ()->FunctionInfo ()->removeLabel (LabelInfo ());
  }
  // cleanup CMemberAliasInfo
  if (MemberAliasInfo ()) {
    if (MemberAliasInfo ()->Scope () && MemberAliasInfo ()->Scope ()->Structure ())
      MemberAliasInfo ()->Scope ()->Structure ()->removeMemberAlias (MemberAliasInfo ());
  }
  // cleanup CTypedefInfo
  if (TypedefInfo ()) {
    if (TypedefInfo ()->Scope () && TypedefInfo ()->Scope ()->Structure ())
      TypedefInfo ()->Scope ()->Structure ()->removeType (TypedefInfo ());
  }
  // cleanup CUsingInfo
  if (UsingInfo ()) {
    if (UsingInfo ()->Scope () && UsingInfo ()->Scope ()->Structure ())
      UsingInfo ()->Scope ()->Structure ()->removeUsing (UsingInfo ());
  }
  // cleanup CTemplateParamInfo
  if (TemplateParamInfo ()) {
    if (TemplateParamInfo ()->TemplateInfo ())
      TemplateParamInfo ()->TemplateInfo ()->removeTemplateParam (TemplateParamInfo ());
    if (TemplateParamInfo ()->ValueType ())
      CTypeInfo::Destroy (TemplateParamInfo ()->ValueType ());
  }
  // cleanup CTemplateInfo
  if (TemplateInfo ()) {
//    for (unsigned i = 0; i < TemplateInfo ()->TemplateParams (); i++) {
//      if (TemplateInfo ()->TemplateParam (i)->TemplateInfo () == TemplateInfo ()) {
//        TemplateInfo ()->TemplateParam (i)->TemplateInfo ((CTemplateInfo*)0);
//        if (! _DeleteMembersOnly)
//          delete TemplateInfo ()->TemplateParam (i);
//      }
//    }
    CTemplateInfo *templ = TemplateInfo ();
    if (templ->isSpecialization () && templ->BaseTemplate ())
      templ->BaseTemplate ()->removeSpecialization (templ);
  }
  // cleanup CRecord
  if (Record ()) {
    CScopeInfo *parent = Record ()->Parent ();
    if (parent && parent->Structure ())
      parent->Structure ()->removeType (Record ());
    if (Record ()->AssignedScope ())
      Record ()->AssignedScope ()->removeType (Record ());
    if (Record ()->TemplateInfo ())
      Record ()->TemplateInfo ()->ObjectInfo ((CObjectInfo*)0);
  }
  // cleanup CNamespaceInfo
  if (NamespaceInfo ()) {
    CScopeInfo *parent = NamespaceInfo ()->Parent ();
    if (parent && parent->Structure ())
      parent->Structure ()->removeNamespace (NamespaceInfo ());
  }
  // cleanup CStructure 
  if (Structure ()) {
    CObjectInfo *info;
    for (unsigned i = 0; i < Structure ()->Objects (); i++) {
      info = Structure ()->Object (i);
      //if (! info->isUser (Structure ())) {      // not only user?
        if (info->TemplateParamInfo ()) {
          if (info->TemplateParamInfo ()->TemplateInfo () == Structure ()) {
            info->TemplateParamInfo ()->TemplateInfo ((CTemplateInfo*)0);
            if (! _DeleteMembersOnly)
              delete info->TemplateParamInfo ();
            }
        } else if (info->ArgumentInfo ()) {
          if (info->ArgumentInfo ()->Scope () == Structure ()) {
            info->ArgumentInfo ()->Scope ((CScopeInfo*)0);
            if (! _DeleteMembersOnly)
              delete info->ArgumentInfo ();
            }
        } else if (info->MemberAliasInfo ()) {
          if (info->MemberAliasInfo ()->Scope () == Structure ()) {
            info->MemberAliasInfo ()->Scope ((CScopeInfo*)0);
            if (! _DeleteMembersOnly) 
              delete info->MemberAliasInfo ();
            }
        } else if (info->EnumeratorInfo ()) {
          if (info->EnumeratorInfo ()->Scope () == Structure ())
            info->EnumeratorInfo ()->Scope ((CScopeInfo*)0);
        } else if (info->AttributeInfo ()) {
          if (info->AttributeInfo ()->Scope () == Structure ()) {
            info->AttributeInfo ()->Scope ((CScopeInfo*)0);
            if (! _DeleteMembersOnly) 
              delete info->AttributeInfo ();
            }
        } else if (info->EnumInfo ()) {
          if (info->EnumInfo ()->Scope () == Structure ()) {
            info->EnumInfo ()->Scope ((CScopeInfo*)0);
            if (! _DeleteMembersOnly)
              delete info->EnumInfo ();
            }
        } else if (info->TypedefInfo ()) {
          if (info->TypedefInfo ()->Scope () == Structure ()) {
            info->TypedefInfo ()->Scope ((CScopeInfo*)0);
            if (! _DeleteMembersOnly)
              delete info->TypedefInfo ();
            }
        } 
      //} else
      //  info->removeUser (Structure ());
    }
    for (unsigned i = 0; i < Structure ()->Usings (); i++) {
      Structure ()->Using (i)->Scope ((CScopeInfo*)0);
      if (! _DeleteMembersOnly)
        delete Structure ()->Using (i);
    }
  }
  // cleanup CScopeInfo
  if (ScopeInfo ()) {
    for (unsigned i = 0; i < ScopeInfo ()->Children (); i++) {
      CScopeInfo *s = ScopeInfo ()->Child (i);
//      if (s->TemplateInfo ())
//        s->TemplateInfo ()->removeLinks ();
      s->Parent ((CScopeInfo*)0);
      if (! _DeleteMembersOnly) {
        if (s->LocalScope ()) delete s->LocalScope ();
        else if (s->FctInstance ()) delete s->FctInstance ();
        else if (s->ClassInstance ()) delete s->ClassInstance ();
        else if (s->UnionInstance ()) delete s->UnionInstance ();
        else if (s->FunctionInfo ()) delete s->FunctionInfo ();
        else if (s->ClassInfo ()) delete s->ClassInfo ();
        else if (s->UnionInfo ()) delete s->UnionInfo ();
        else if (s->TemplateInfo ()) delete s->TemplateInfo (); 
        else if (s->NamespaceInfo () && ! s->FileInfo ()) 
          delete s->NamespaceInfo ();
      }
    }
    if (ScopeInfo ()->Parent () && ScopeInfo ()->Parent () != ScopeInfo ())
      ScopeInfo ()->Parent ()->removeChild (ScopeInfo ()); 
  }
  // cleanup CObjectInfo
  if (Structure ())
    Structure ()->removeRegisterEntry ();
  if (SemDB ())
    SemDB ()->Remove ((CObjectInfo*)this);
//  if (_Name) 
//    delete[] _Name; 
  if (_QualName) 
    delete[] _QualName; 
  CTypeInfo::Destroy (_TypeInfo);
  Unlink ();
}

void CObjectInfo::Unregister (CStructure *scope) { 
  for (unsigned i = 0; i < (unsigned)_Registered.length (); i++) 
    if (_Registered.lookup (i) == scope)
      _Registered.remove (i); 
}

bool CObjectInfo::isRegistered (const CStructure *scope) const {
  for (unsigned i = 0; i < (unsigned)_Registered.length (); i++) 
    if (_Registered.lookup (i) == scope)
      return true;
  return false;
}

void CObjectInfo::NextObject (CObjectInfo *o) { 
  if (o) { 
    o->_Next = _Next; 
    o->_Prev = this;
    _Next->_Prev = o; 
    _Next = o; 
  } 
}

void CObjectInfo::PrevObject (CObjectInfo *o) { 
  if (o) { 
    o->_Prev = _Prev; 
    o->_Next = this;
    _Prev->_Next = o; 
    _Prev = o; 
  } 
}

void CObjectInfo::Unlink () { 
  _Prev->_Next = _Next; 
  _Next->_Prev = _Prev; 
}

CTemplateInstance *CObjectInfo::TemplateInstance () const { 
  if (ClassInstance ())
    return ClassInstance ()->TemplateInstance ();
  else if (FctInstance ())
    return FctInstance ()->TemplateInstance ();
  else if (UnionInstance ())
    return UnionInstance ()->TemplateInstance ();
  return (CTemplateInstance*)0; 
}

bool CObjectInfo::isClassMember () const {
  return AttributeInfo () ? AttributeInfo ()->Record () :
         FunctionInfo () ? FunctionInfo ()->Record () : false;
}

CRecord *CObjectInfo::ClassScope () const {
  if (AttributeInfo ())
    return AttributeInfo ()->Record ();
  if (FunctionInfo ())
    return FunctionInfo ()->Record ();
  return (CRecord*)0;
}

bool CObjectInfo::operator ==(const CObjectInfo &info) const {
  CObjectInfo *oi1, *oi2;
  oi1 = (CObjectInfo*)this;
  oi2 = (CObjectInfo*)(&info);
  do {
    if (oi1 == oi2)
      return true;
    oi1 = oi1->NextObject ();
  } while (oi1 != (CObjectInfo*)this);
  return false;
}

CScopeInfo *CObjectInfo::Scope () const { 
  if (ScopeInfo ())
    return ScopeInfo ()->Parent ();
  else 
    return TypedefInfo () ? TypedefInfo ()->Scope () :
           EnumInfo () ? EnumInfo ()->Scope () :
           MemberAliasInfo () ? MemberAliasInfo ()->Scope () :
           EnumeratorInfo () ? EnumeratorInfo ()->Scope () :
           AttributeInfo () ? AttributeInfo ()->Scope () :
           TemplateParamInfo () ? TemplateParamInfo ()->TemplateInfo () :
           ArgumentInfo () ? ArgumentInfo ()->Scope () : 
           LabelInfo () ? LabelInfo ()->Scope () : 
           (CScopeInfo*)0; // Should never be reached.
}

bool CObjectInfo::isTemplate () const { 
  return Record () ? Record ()->isTemplate () :
         FunctionInfo () ? FunctionInfo ()->isTemplate () : 
         TemplateParamInfo () ? TemplateParamInfo ()->isTemplate () : false; 
}

void CObjectInfo::TypeInfo (CTypeInfo *info) { 
  if (_TypeInfo && _TypeInfo != info) 
    CTypeInfo::Destroy (_TypeInfo);
  _TypeInfo = info; 
}

void CObjectInfo::Name (const DString& name) {
  if (_Name.empty() == false ) {
    CObjectInfo *scope = this->AssignedScope ();
    if (! scope) {
      scope = this->Scope (); 
    }
    if (scope) {
      CStructure* scopeStruct = scope->Structure();
      assert(scopeStruct != 0);
      scopeStruct->removeObjectName(name,this);
    }
  }
  _Name = name;
  CObjectInfo *scope = this->AssignedScope ();
  if (! scope) {
    scope = this->Scope (); 
  }
  if (scope) {
    CStructure* scopeStruct = scope->Structure();
    assert(scopeStruct != 0);
    scopeStruct->addObjectName(this);
  }
}

const char *CObjectInfo::QualName (bool abs, bool tdef) {
  if ((! _QualName && _Name.empty() == false) || abs != _abs || tdef != _tdef) {
//    // for template instances the qualified name is the name of the template
    CObjectInfo *obj = this;
//    if (TemplateInstance ())
//      obj = TemplateInstance ()->Template ();
      
    // get the scope object
    CScopeInfo *info = obj->QualifiedScope ();
  	if (!info) info = obj->AssignedScope (); 
    if (!info) info = obj->Scope ();

		// if this an anonymous (generated) template scope, skip it
		while (info && info->isNamespace () && info->isAnonymous () &&
		  !info->GlobalScope ()) {
			info = info->Scope ();
		}
    
    std::ostringstream qname;
    if (info->TypeInfo () && info->TypeInfo ()->isRecord ()) {
	    // if the scope has an associated type we can use CTypeInfo::TypeText ()
    	info->TypeInfo ()->TypeText (qname, 0, abs, tdef);
    	qname << "::";
    }
    else { 
  		// if the scope is not a type we run through all the namespace 
	    Array<const char*> scopes;
  	  while (info && ! info->isAnonymous () &&
    	       (info->Record () || 
      	      (info->NamespaceInfo () && ! info->FileInfo ()))) {
      	scopes.append (info->Name ());
      	info = info->Scope (); 
    	}
	    if (abs)
  	  	qname << "::";
    	for (long i = scopes.length () - 1; i >= 0; i--)
      	qname << scopes.lookup (i) << "::";
    }
    qname << _Name.c_str ();
    _QualName = StrCol::dup (qname.str ().c_str ());
    
    // remember these parameters, because on a different request the name
    // has to be regenerated
    _abs = abs;
    _tdef = tdef;
  }
  return _QualName;
}

CObjectInfo *CObjectInfo::DefObject () const { 
  if (ClassInfo ())
    return ClassInfo ()->DefObject ();
  else if (UnionInfo ())
    return UnionInfo ()->DefObject ();
  else if (FunctionInfo ())
    return FunctionInfo ()->DefObject ();
  else if (EnumInfo ())
    return EnumInfo ()->DefObject ();
  return ObjectInfo (); 
}

CTemplateInfo *CObjectInfo::Template () const { 
  return Record () ? Record ()->TemplateInfo () :
         FunctionInfo () ? FunctionInfo ()->TemplateInfo () : 
         TemplateParamInfo () ? TemplateParamInfo ()->TemplateInfo () : 
         (CTemplateInfo*)0; 
}

//CStructure *CObjectInfo::User (const char *name) const { 
//  for (unsigned i = 0; i < Users (); i++) 
//    if (! strcmp (User (i)->Name (), name)) 
//      return User (i);
//  return (CStructure*)0;
//}

//void CObjectInfo::addUser (CStructure *info) { 
//  if (! isUser (info))
//    _Users.append (info); 
//}

//void CObjectInfo::removeUser (const CStructure *info) { 
//  for (unsigned i = 0; i < Users (); i++) 
//    if (User (i) == info) {
//      _Users.remove (i); 
//      break;
//    }
//}

//bool CObjectInfo::isUser (const CStructure *info) const {
//  for (unsigned i = 0; i < Users (); i++) 
//    if (User (i) == info) 
//      return true;
//  return false;
//}


} // namespace Puma
