// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Transformer_h__
#define __Transformer_h__

#include "CodeWeaver.h"

#include "Puma/CCParser.h"
#include "Puma/CCSemVisitor.h"
using namespace Puma;

#include <list>
using std::list;

namespace Puma {
  class VerboseMgr;
  class ErrorStream;
  class CProject;
  class CSemDatabase;
  class ACAspectInfo;
  class ACIntroductionInfo;
  class CTranslationUnit;
  class CT_AdviceDecl;
} // namespace Puma

class PointCut;
class Repository;
class Plan;
class ModelBuilder;
class ACConfig;
class IncludeGraph;

class Transformer
 {
      VerboseMgr &_vm;
      ErrorStream &_err;
      CProject &_project;
      Repository &_repo;
      CodeWeaver _code_weaver;
      CCParser _parser;
      CCSemVisitor _sem_visitor;
      ACConfig &_conf;
      string _aspect_includes;
      
      bool phase1 (Unit *unit, CTranslationUnit *&, ModelBuilder &);
      bool phase2 (Unit *unit, CTranslationUnit *, ModelBuilder &);
      void determine_aspect_includes (const IncludeGraph &ig);
      string aspect_include_cluster (const char *ah_file,
        const IncludeGraph &ig);
      void determine_aspect_cluster (const Unit* ah_unit,
        const IncludeGraph &ig, set<const Unit*> &cluster);
      void prepare_dynamic_weaving (ModelBuilder &jpm);
      void update_intros_in_repo (ModelBuilder &);
      void aspect_priviledges (ModelBuilder &);
      void cleanup (CTranslationUnit &tunit);
      void orderings (CTranslationUnit &, Plan&, ModelBuilder &, bool);
      void introductions (CTranslationUnit &, ModelBuilder &);
      void advice (CTranslationUnit &tunit);
      void singleton_aspects (CTranslationUnit &);
      void join_points (CTranslationUnit &, ModelBuilder &, Plan &);
   public:

      Transformer (VerboseMgr &vm, ErrorStream &e, CProject &p, Repository &r,
                   ACConfig &c, LineDirectiveMgr &ldm):
      	_vm (vm), _err (e), _project (p), _repo (r), _code_weaver (e, ldm),
      	_sem_visitor (e), _conf (c) {}
      void work (Unit *unit, Token *primary_start, Token *primary_end);
      const string &aspect_includes () const { return _aspect_includes; }
 };

#endif // __Transformer_h__
