#include "IconCache.h"
#include "Icon.h"
#include "IconLoader.h"

Icon *IconCache::Find(char name) {
  Chain *e = first;
  while (e) {
    if (((Icon*)e)->Name() == name) {
//      cout << " fount " << ((Icon*)e)->Name() << "(" << name << ") ";
      hit++;
      return (Icon*)e;
    }
    else e = e->select();
  }
  miss++;
  return 0;
}

void IconCache::Insert(Chain *i) {
  if (!i) return;
  if (fill+1 == max) CleanUp();
  i->append(first);
  fill++;
  first = i;
}

void IconCache::CleanUp() {
  clean++;
  Chain *e = first;
  for (unsigned i=0; (i<min) && e; i++) e = e->select();
  if (!e) return;
  Chain *t;
  do {
    t = e->select();
    e->append(t->select());
    delete (Icon*)t;
    fill--;
    e = e->select();
  } while (e);
}
