// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CodeWeaver_h__
#define __CodeWeaver_h__

// The code weaver allows AspectC++ specific code manipulation transactions.
// All access to the syntax tree nodes for the transformation is 
// encapsulated here.
// The class does not know about class JoinPoint. It only knows join point
// locations (JPL_*).

#include <iostream>
#include <set>
#include <map>
using namespace std;

#include "PointCut.h" // Oh no, it knows JoinPoint
#include "WeaverBase.h"
#include "AspectIncludes.h"
#include "SyntacticContext.h"

#include "Puma/CUnit.h"
#include "Puma/CProtection.h"
using namespace Puma;

namespace Puma {
  class CTree;
  class CClassInfo;
  class CProject;
} // namespace Puma

class ACM_Any;
class ACM_Class;
class ACM_Execution;
class ACM_Call;
class ACM_Code;
class ACM_CodePlan;

class AspectInfo;
class AdviceInfo;
class ThisJoinPoint;
class ResultBuffer;
class TI_MethodCall;

class CodeWeaver : public WeaverBase {
      AspectIncludes _aspect_includes;
      BackEndProblems _problems;
      set<Token*> _bypass_blacklist;
      map<CClassInfo*, ACM_Class*> _bypass_map;

      void make_check_function (bool in_checked,
                                CRecord *in, CRecord *check_for);
      void make_tjp_typename (ostream &out, ACM_Code *loc, int depth, ResultBuffer &rb);
      
      void make_proceed_code (ostream &out, ACM_Any *loc, bool action,
                              vector<string> *arg_names = 0);
      void make_advice_call(ostream &out, ACM_Any *loc, AdviceInfo *ad,
                            bool inter, int depth);
      void make_advice_calls (ostream &out, ACM_CodePlan *plan,
                              ACM_Any *loc, bool inter = false, vector<string> *arg_names = 0);
      void make_action_wrapper(ostream &impl, ACM_Code *jpl, int depth);
      void make_proceed_func(ostream &impl, ACM_Any *loc, ACM_CodePlan *plan);
      string wrapper_function_signature (ACM_Code *loc,
          const SyntacticContext &sctxt, bool def);
      void gen_special_member_function (ACM_Code *loc);
      void wrap_function (ACM_Code *loc);
      void wrap_function_def (ACM_Code *loc, const SyntacticContext &sctxt,
        bool wrapped_decl);
      bool wrap_function_decl (ACM_Code *loc, const SyntacticContext &sctxt);
      void wrap_attribute_arrays (CT_MembList *members);
      void gen_wrapped_array (ostream &out, CObjectInfo *obj);
      void gen_binding_templates (ostream &out, ACM_CodePlan *plan, const char *jpname);

      bool check_special_member_function (CFunctionInfo *func);
      void setup_tjp (ThisJoinPoint &tjp, CTree *node);
      void insert_id_class (ACM_Call *loc, ACM_Name *src_obj, const WeavePos &pos,
          ACM_Function &dst_func);

      // scope functions
      CClassInfo *cscope (CObjectInfo *obj);
      ACM_Class *cscope (ACM_Name *obj);
      ACM_Name *nscope (ACM_Function *func);
      string cleanup_name(const string& in);

      // not a very good function
      void print_tree (ostream &out, CTree *node, bool expand_implicit_calls = false);

      void rename_args (const SyntacticContext &sctxt, const char * new_name,
          vector<string> &arg_names);
      void rename (CArgumentInfo *arg, const string &new_name);
      CT_SimpleName *is_name (CTree *node);
      CT_FctDeclarator *fct_declarator (CT_Declarator *declarator);
      CT_SimpleName *name (CT_Declarator *&declarator);

      // return LinkageSpec node for extern "C" <decl> like declarations
      CTree *linkage_adjust (CT_Decl *decl);

   public:

      CodeWeaver (ErrorSink& e, LineDirectiveMgr &ldm) :
        WeaverBase (e, ldm) {}

      // set weaver parameters
      void problems (const BackEndProblems &problems) { _problems = problems; }

      // get weaver parameters
      const BackEndProblems &problems () const { return _problems; }

      void setup_tjp (ThisJoinPoint &tjp, CFunctionInfo* func);
      void insert_namespace_ac ();
      void insert_invocation_functions (ACM_Aspect *jpl_aspect, const string &defs);
      void open_namespace (ostream &out, CObjectInfo *obj);
      void close_namespace (ostream &out, CObjectInfo *obj);
      
      void make_tjp_struct(ostream &out, ACM_Code *loc,
          ACM_CodePlan *plan, const ThisJoinPoint &tjp);
      void exec_join_point (ACM_Execution *loc);
      void call_join_point (ACM_Call *loc);
      void cons_join_point (ACM_Construction *loc);
      void dest_join_point (ACM_Destruction *loc);
      void add_aspect_include (ACM_Any *jpl, AspectInfo &aspect_info,
                               AspectRef::Kind kind);
      void aspect_includes (CProject &project);
      AspectIncludes &aspect_includes () { return _aspect_includes; }
      void type_check (const ACM_Class *in, const string &name, bool result);

      void bypass_info_clear ();
      bool bypass_in_blacklist (ACM_Class *cls);
      void bypass_insert (ACM_Class *cls);

      // code transformation functions need for phase 1:
      void transform_aspect(Puma::Token *start);
      void transform_pointcut_def(Puma::Token *start, Puma::Token *virtual_token,
          Puma::Token *assignment_token, Puma::Token *pct_end_token);
      void transform_advice_code (int no, std::string kind, AdviceCodeContext context,
          bool has_args, Puma::Token *arg_begin, Puma::Token *body_begin, Puma::Token *body_end,
          const string &prot);
      void transform_aspectof (AdviceCodeContext context,
          Token *start, Token *name, Token *arg_begin,
          Token *body_begin, Token *body_end, const string &prot);
      void transform_delete (Puma::Token *from, Puma::Token *to);
 };

#endif // __CodeWeaver_h__
