
#include "hash-t.hh"

#include "repl.hh"
#include "map_repl.hh"
#include "refcount.hh"

namespace afilter {

  template <typename T>
  class SingleRepl : public T::Base, 
		     public MapReplBase<typename T::InValue, typename T::Value> 
  {
  public:
    typedef typename T::Base        Base;
    typedef typename T::Itr         Itr;
    typedef typename T::InValue     InValue;
    typedef typename T::Value       Value;
    typedef typename T::ItrRoot     ItrRoot;
    typedef typename T::Buffer      Buffer;
    typedef typename T::SingleMulti SingleMulti;

    typedef MapReplBase<typename T::InValue, typename T::Value> M;
    typedef typename M::InString InString;
    typedef typename M::String   String;

  private:
    typedef hash_map<InValue,String> Lookup;
    RefCount<Lookup> lookup;
  
  public:
    SingleRepl(ConfigData *, const ReplOpts *) {}

    Base * clone() const {return new SingleRepl(*this);}
    void assign(const Base * other) {*this = *(const SingleRepl *)(other);}
  
    bool fill(InValue c, Itr *, Buffer * buffer) {
      typename Lookup::iterator i = lookup->find(c);
      if (i == lookup->end()) return false;
      add_to_buffer(*buffer, i->second, SingleMulti());
      return true;
    }
    void add (const InValue * k, const Value * v) {
      pair<const InValue,String> temp(*k,String());
      for (; *v != '\0'; ++v)        
	temp.second.push_back(*v);
      lookup->insert(temp);
    }
  };
}
