#include <ctime>

#include "simple_fstream.hh"
#include "data.hh"


namespace aspell {

  namespace writable_base {

    class WritableBaseCode {
    protected:
      string suffix;
      string compatibility_suffix;

      time_t cur_file_date;

      string compatibility_file_name;

      WritableBaseCode(const char * s, const char * cs)
	: suffix(s), compatibility_suffix(cs) {}
      virtual ~WritableBaseCode() {}

      virtual void save(SimpleFstream &, const string &) = 0;
      virtual void merge(SimpleFstream &, const string &, 
			 Config * config = 0) = 0;

      virtual const char * file_name() = 0;

      virtual void set_file_name(const string & name) = 0;
      virtual void update_file_info(SimpleFstream & f) = 0;

      void save2(SimpleFstream &, const string &);
      void update(SimpleFstream &, const string &);
      void save(bool do_update);
      void update_file_date_info(SimpleFstream &);
      void load(const string &, Config *);
      void merge(const string &);
      void save_as(const string &);
    };

    template <typename Base>
    class WritableBase : public Base, public WritableBaseCode 
    {
    protected:
      void set_file_name(const string & name) {
	Base::set_file_name(name);
      }
      void update_file_info(SimpleFstream & f) {
	Base::update_file_info(f);
      }
    public:
      WritableBase(const char * s, const char * cs) 
	: WritableBaseCode(s,cs) {}
      
      const char * file_name() {
	return Base::file_name();
      }

      void load(const string & f, Config * c, 
		Manager *, const LocalWordSetInfo *) { 
	WritableBaseCode::load(f,c);
      };
      void merge(const string & f) {
	WritableBaseCode::merge(f);
      };
      void save_as(const string & f) {
	WritableBaseCode::save_as(f);
      }
      void synchronize() {
	WritableBaseCode::save(true);
      }
      void save_noupdate() {
	WritableBaseCode::save(false);
      }
    };
  }
}
