/** \file src/main.hh */
/*
 * This file is part of assoGiate,
 * an editor of the file types database for GNOME.
 *
 * Copyright (C) 2007 Kevin Daughtridge <kevin@kdau.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ASSOGIATE__MAIN_HH
#define ASSOGIATE__MAIN_HH

#include <libassogiate/mime-database.hh>
#include "type-dialog.hh"

#include <glibmm/optiongroup.h>
#include <gtkmm/entry.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/window.h>

/******************************************************************************/
namespace assoGiate {
/******************************************************************************/

int main(int& argc, char**& argv);

/******************************************************************************/
class MainOptionGroup : public Glib::OptionGroup {
/******************************************************************************/

public:

	MainOptionGroup();
	
	bool m_user;

}; /* class MainOptionGroup */

/******************************************************************************/
class MainWindow : public Gtk::Window {
/******************************************************************************/

public:

	MainWindow(bool want_user_db);
	virtual ~MainWindow();

private:

	void on_database_toggled();
	void switch_database(bool user_db);
	void on_database_changed();

	void on_category_changed();

	void on_selection_changed();
	void on_right_click(guint32 time);
	
	void store_selection();
	void restore_selection();

	void on_import_types();
	void on_export_types();
	void on_clear_types();

	void on_new_type();
	void on_edit_type();

	void type_dialog_common(TypeDialog& dialog);
	void on_hide_type_dialog(TypeDialog* dialog);

	void on_revert_type();
	void on_delete_type();
	void remove_type_common(const ustring& primary, const ustring& secondary,
		const Gtk::StockID& stock);
	
	void on_find_type();
	void on_find_changed();
	void on_cancel_find();
	
	void on_help_contents();
	void on_help_about();

	bool m_user_db;
	RefPtr<Gtk::RadioAction> m_system_db_action;

	RefPtr<MimeDatabase> m_database;
	Location m_target;

	RefPtr<Gtk::UIManager> m_ui;
	RefPtr<Gtk::ActionGroup> m_actions;

	RefPtr<Gtk::TreeSelection> m_categories_sel;
	RefPtr<TypesStore> m_types;
	TypesView m_types_view;
	TypesColumns &m_types_cols;
	ustring m_last_selected;
	
	Gtk::HBox m_find_box;
	Gtk::Entry m_find_entry;
	
	std::list<TypeDialog*> m_type_dialogs;

}; /* class MainWindow */

} /* namespace assoGiate */

#endif /* ASSOGIATE__MAIN_HH */
