/** \file src/misc.hh */
/*
 * This file is part of assoGiate,
 * an editor of the file types database for GNOME.
 *
 * Copyright (C) 2007 Kevin Daughtridge <kevin@kdau.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ASSOGIATE__MISC_HH
#define ASSOGIATE__MISC_HH

#include <libassogiate/mime-database.hh>

#include <gtkmm/button.h>
#include <gtkmm/dialog.h>
#include <gtkmm/frame.h>
#include <gtkmm/table.h>
#include <gtkmm/treeview.h>

/******************************************************************************/
namespace assoGiate {
/******************************************************************************/

void die_on_database_load_error(const MimeDatabaseLoadError& e) throw();

void show_database_update_warning(const MimeDatabaseUpdateError& e,
	Gtk::Window* parent) throw();

void activate_url(Gtk::Window& source, const ustring& url) throw();
void activate_email(Gtk::Window& source, const ustring& address) throw();
void activate_help(Gtk::Window& source, const ustring& link=ustring()) throw();

ustring get_location_name(Location locations) throw();

/******************************************************************************/
class InfoTable : public Gtk::Table {
/******************************************************************************/

public:

	InfoTable();
	
	void add_item(const ustring& text, Gtk::Widget& item);
	void add_item(const ustring& text, Gtk::Widget& item, Gtk::Widget& target);
	void add_item(Gtk::Widget& label, Gtk::Widget& item);

private:

	int m_row;

}; /* class InfoTable */

/******************************************************************************/
class AddItemDialog : public Gtk::Dialog {
/******************************************************************************/

public:

	AddItemDialog(Gtk::Window* parent, const ustring& title);

	void add_item(const ustring& text, Gtk::Widget& item, bool required);
	void add_item(const ustring& text, Gtk::Widget& item, Gtk::Widget& target,
		bool required);
	void add_required(Gtk::Widget& required);

private:

	void update();

	InfoTable m_table;
	std::list<Gtk::Widget*> m_required;

	Gtk::Button *m_add;

}; /* class AddItemDialog */

/******************************************************************************/
class EditableColumnsBase : public Gtk::TreeModelColumnRecord {
/******************************************************************************/

public:

	Gtk::TreeModelColumn<bool> removable;

protected:

	EditableColumnsBase();

private:

	friend class EditableListView;
	static EditableColumnsBase& get();

}; /* class EditableColumnsBase */

/******************************************************************************/
class EditableListView : public Gtk::Frame {
/******************************************************************************/

public:

	explicit EditableListView(const RefPtr<Gtk::TreeModel>& store,
		const ustring& title = ustring());

	sigc::signal<void> signal_add();
	sigc::signal<void, Gtk::TreeIter> signal_remove();

	Gtk::TreeView m_view;

private:

	void on_selection_changed();
	void on_do_add();
	void on_do_remove();
	
	Gtk::HButtonBox m_bbox;
	Gtk::Button m_add, m_remove;
	
	sigc::signal<void> s_add;
	sigc::signal<void, Gtk::TreeIter> s_remove;

}; /* class EditableListView */

} /* namespace assoGiate */

#endif /* ASSOGIATE__MISC_HH */
