#ifndef DECOR_DEFINE
#define DECOR_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"
#include "physobj.h"

enum	decorTypes {
	DECOR_SMOKE,
};

class DECOR: public PHYSICAL_OBJECT
{
	public:
	int	type;
	int	radius;
	int	color;

	DECOR ();
	~DECOR ();
	DECOR (GLOBALDATA *global, ENVIRONMENT *env, double xpos, double ypos, double xvel, double yvel, int maxRadius, int decorType);
	void	draw (BITMAP *dest);
	int	applyPhysics ();
	void	initialise ();
	int	isSubClass (int classNum);
	int	getClass () {return (DECOR_CLASS);};
};

#endif
