#ifndef GLOBALDATA_DEFINE
#define GLOBALDATA_DEFINE
/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"

enum skipComputerPlayType {
	SKIP_NONE, SKIP_HUMANS_DEAD, SKIP_AUTOPLAY
};

class PLAYER;
class TANK;
class GLOBALDATA {
	public:
	int	WHITE, BLACK, PINK;
	double	slope[360][2];

	char	*dataDir;
	BOX	*updates, *lastUpdates, window;
	int	updateCount, lastUpdatesCount;
	int	stopwindow;
	int	command;

	PLAYER	**allPlayers;
	int	numPermanentPlayers;
	PLAYER	**players;
	int	numPlayers;
	int	numHumanPlayers;
	int	computerPlayersOnly;
	double	skipComputerPlay;	/* options requires doubles - grr */
					/* It's a lot simpler than having
					 * special cases for each type */
	int	numTanks;
	int	maxNumTanks;
	TANK	*currTank;

	int	updateMenu;

	int	curland, cursky;

	int	colourDepth;
	int	screenWidth, screenHeight;
	int	halfWidth, halfHeight;
	gfxDataStruct	gfxData;
	DATAFILE	*SOUND;


	int		cacheCirclesBG ;	/* This is just a flag, so it need only be
								an integer, not a double */

	/* Logically, these three variables should be ints.  However, converting
	them to ints (or even an enumerated type) would require some rewritting
	of the options function - and that's a lot of work. 2003.09.05 */
	/* Hence being double. 2004.01.05 */
	double ditherGradients;
	double detailedLandscape;
	double detailedSky;

	/* All this money data; couldn't it be moved into some separate data
	structure or object */
	/* It could, but it's not a problem */
	double	startmoney;
	double	interest;
	double	scoreHitUnit;
	double	scoreSelfHit;
	double	scoreUnitDestroyBonus;
	double	scoreUnitSelfDestroy;
	double	scoreRoundWinBonus;
	double  sellpercent;

	/* double? */
	/* double for options() reasons, no messing about with casting or
	 * special cases. */
	double	turntype;
	double	rounds;
	int     currentround;

	GLOBALDATA ();
	void	initialise ();
	int	saveToFile (FILE *file);
	int	loadFromFile (FILE *file);
	void	addPlayer (PLAYER *player);
	void	removePlayer (PLAYER *player);
	PLAYER	*getNextPlayer (int *playerCount);
	PLAYER	*createNewPlayer (ENVIRONMENT *env);
	void	destroyPlayer (PLAYER *player);
};

#endif
