#ifndef MAIN_DEFINE
#define MAIN_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include <allegro.h>
#ifdef WIN32
#define	VERSION	"1.0.0"
#include <winalleg.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include "imagedefs.h"

#include <iostream>
        
#ifdef LINUX    
#include <unistd.h>
#endif /* LINUX */

#include <string>

#ifdef LINUX
#define LINUX_SLEEP usleep(1)
#else
#define LINUX_SLEEP 
#endif

using namespace std;

#ifndef	DATA_DIR
#define	DATA_DIR	"."
#endif
#define SCREEN_WIDTH	800
#define SCREEN_HEIGHT	600
#define HALF_WIDTH	(SCREEN_WIDTH/2)
#define HALF_HEIGHT	(SCREEN_HEIGHT/2)
#define	STUFF_BAR_WIDTH		400
#define	STUFF_BAR_HEIGHT	35

#define	GFILE_KEY	0x14233241

#define	FRAMES_PER_SECOND	60
#define PI 3.14
#define MAXUPDATES 10000
#define MAXPLAYERS 10
#define MAX_POWER  2000
#define MAX_OBJECTS 400
#define	MAX_ROUNDS 1000
#define TANKHEIGHT 20
#define TANKWIDTH 15
#define GUNLENGTH 16
#define MENU 30
#define SKIES 8
#define LANDS 8
#define	BALLISTICS 42
#define	BEAMWEAPONS 3
#define WEAPONS (BALLISTICS + BEAMWEAPONS)
#define ITEMS 17
#define THINGS (WEAPONS + ITEMS)
#define	NATURALS 6
#define RADII 6
#define MAXRADIUS 200
#define BUTTONFRAMES 2
#define EXPLODEFRAMES 18
#define	DISPERSEFRAMES 10
#define	EXPLOSIONFRAMES	(EXPLODEFRAMES + DISPERSEFRAMES)
#define TANKSAG 10
#define MENUBUTTONS 6
#define MISSILEFRAMES 1
#define ACHANGE 256/360
#define INGAMEBUTTONS 3
#define MAX_MISSILES 10
#define SPREAD 10
#define SHIELDS 6
#define WEAPONSOUNDS 4

//Score coeficients

#define SCORE_DESTROY_UNIT_BONUS	5000
#define SCORE_UNIT_SELF_DESTROY		0
#define SCORE_HIT_UNIT			50
#define SCORE_SELF_HIT			0

//Wind
#define WIND_COEF			0.3
#define	MAX_WIND			3


//turns
enum turnTypes {
	TURN_HIGH, TURN_LOW, TURN_RANDOM
};

//options
//#define	OPT_GRAVITY		0
//#define	OPT_WINDSTRENGTH	1
//#define	OPT_WINDVARIATION	2
//#define	OPT_STARTMONEY		3
//#define	OPT_TURNTYPE		4

class BOX
{
	public:
	int 	x, y, w, h;
};


typedef struct gradient_struct {
  RGB	color;
  float	point;
} gradient;

class WEAPON
{
	public:
	char		*name;		//name of weapon
	char		*description;
	int		cost;		//$ :))
	int		amt;		//number of weapons in one package
	double		mass;
	double		drag;
	int		radius;
	int		sound;
	int		etime;
	int		damage;		//damage power
	int		eframes;
	int		picpoint;
	int		spread;
	int		delay;		// volleys etc.
	char		noimpact;
	int		techLevel;
	char		warhead;	// Is it a warhead?
	int		numSubmunitions;// Number of submunitions
	int		submunition;	// The next stage
	double		impartVelocity;	// Impart velocity 0.0-1.0 to subs
	int		divergence;	// Total angle for submunition spread
	double		spreadVariation;// Uniform or random distribution
					//   0-1.0 (0=uniform, 1.0=random)
					//   divergence at centre of range
	double		launchSpeed;	// Speed given to submunitions
	double		speedVariation;	// Uniform or random speed
					//   0-1.0 (0=uniform, 1.0=random)
					//   launchSpeed at centre of range
	int		countdown;	// Set the countdown to this
	double		countVariation;	// Uniform or random countdown
					//   0-1.0 (0=uniform, 1.0=random)
					//   countdown at centre of range
};

#define	MAX_ITEMVALS	10
class ITEM
{
	public:
	char		*name;
	char		*description;
	int		cost;
	int		amt;
	char		selectable;
	int		techLevel;
	int		sound;
	double		vals[MAX_ITEMVALS];
};
enum shieldVals {
	SHIELD_ENERGY,
	SHIELD_REPULSION,
	SHIELD_RED,
	SHIELD_GREEN,
	SHIELD_BLUE,
	SHIELD_THICKNESS,
};
enum selfDestructVals {
	SELFD_TYPE,
	SELFD_NUMBER,
};

enum weaponType {
	SML_MIS, MED_MIS, LRG_MIS, SML_NUKE, NUKE, DTH_HEAD,
	SML_SPREAD, MED_SPREAD, LRG_SPREAD, SUP_SPREAD, DTH_SPREAD, ARMAGEDDON,
	SHAPED_CHARGE, WIDE_BOY, CUTTER,
	SML_ROLLER, LRG_ROLLER, DTH_ROLLER,
	CLUSTER, SUP_CLUSTER,
	FUNKY_BOMB, FUNKY_DEATH,
	FUNKY_BOMBLET, FUNKY_DEATHLET,
	BOMBLET, SUP_BOMBLET,
	BURROWER, PENETRATOR,
	SML_NAPALM, MED_NAPALM, LRG_NAPALM,
	NAPALM_JELLY,
	TREMOR, SHOCKWAVE, TECTONIC,
	RIOT_BOMB, HVY_RIOT_BOMB,
	RIOT_CHARGE, RIOT_BLAST,
	DIRT_BALL, LRG_DIRT_BALL, SUP_DIRT_BALL,
	SML_LAZER, MED_LAZER, LRG_LAZER,
	SML_METEOR, MED_METEOR, LRG_METEOR,
	SML_LIGHTNING, MED_LIGHTNING, LRG_LIGHTNING
};

#define LAST_EXPLOSIVE	NAPALM_JELLY

#define ITEM_NO_SHIELD			-1
enum itemType {
	ITEM_TELEPORT,
	ITEM_VENGEANCE,
	ITEM_DYING_WRATH,
	ITEM_FATAL_FURY,
	ITEM_LGT_SHIELD,
	ITEM_MED_SHIELD,
	ITEM_HVY_SHIELD,
	ITEM_LGT_REPULSOR_SHIELD,
	ITEM_MED_REPULSOR_SHIELD,
	ITEM_HVY_REPULSOR_SHIELD,
	ITEM_ARMOUR,
	ITEM_PLASTEEL,
	ITEM_INTENSITY_AMP,
	ITEM_VIOLENT_FORCE,
	ITEM_SLICKP,
	ITEM_DIMPLEP,
	ITEM_PARACHUTE,
};

#define SHIELD_COUNT		6

//signals
#define	SIG_QUIT_GAME		-1
#define SIG_OK			0
#define GLOBAL_COMMAND_QUIT		-1
#define GLOBAL_COMMAND_MENU		0
#define GLOBAL_COMMAND_OPTIONS		1
#define GLOBAL_COMMAND_PLAYERS		2
#define GLOBAL_COMMAND_CREDITS		3
#define	GLOBAL_COMMAND_HELP		4
#define GLOBAL_COMMAND_PLAY         5

// Classes
#define	ANY_CLASS		-1
#define	VIRTUAL_OBJECT_CLASS	0
#define	FLOATTEXT_CLASS		1
#define	PHYSICAL_OBJECT_CLASS	2
#define	MISSILE_CLASS		3
#define	TANK_CLASS		4
#define	EXPLOSION_CLASS		5
#define	TELEPORT_CLASS		6
#define	BEAM_CLASS		7
#define	DECOR_CLASS		8


typedef struct {
	DATAFILE	*M, *T, *TITLE, *S, *E, *B, *L, 
			*TG, *MI, *STOCK_IMAGE;

	BITMAP		*sky_gradient_strips[SKIES];
	BITMAP		*land_gradient_strips[LANDS];
	BITMAP		*circle_gradient_strip;
	BITMAP		*stuff_bar_gradient_strip;
	BITMAP		*topbar_gradient_strip;
	BITMAP		*explosion_gradient_strip;
	BITMAP		*stuff_bar[2];
	BITMAP		*stuff_icon_base;
	BITMAP		*circlesBG;
	BITMAP		*topbar;
	BITMAP		*explosions[EXPLOSIONFRAMES];
	BITMAP		*flameFront[EXPLOSIONFRAMES];
} gfxDataStruct;



class GLOBALDATA;
class ENVIRONMENT;
int drawFracture (GLOBALDATA *global, ENVIRONMENT *env, BITMAP *dest, BOX *updateArea, int x, int y, int angle, int width, int segmentLength, int maxRecurse, int recurseDepth);
int setSlideColumnDimensions (GLOBALDATA *global, ENVIRONMENT *env, int x, char reset);
double Noise (int x);
double Noise2D (int x, int y);
double interpolate (double x1, double x2, double i);
double perlin1DPoint (double amplitude, double scale, double xo, double lambda, int octaves);
double perlin2DPoint (double amplitude, double scale, double xo, double yo, double lambda, int octaves);

void quickChange (GLOBALDATA *global, BITMAP *target) ;
void change(GLOBALDATA *global, BITMAP *target);

int checkPixelsBetweenTwoPoints (GLOBALDATA *global, ENVIRONMENT *env, double *startX, double *startY, double endX, double endY);
long int calcTotalPotentialDamage (int weapNum);
long int calcTotalEffectiveDamage (int weapNum);


#define GENSKY_DETAILED		1
#define GENSKY_DITHERGRAD	2
void generate_sky (GLOBALDATA *global, BITMAP* bmp, const gradient* grad, int flags ) ;


#include "externs.h"

#endif

