import os
import imp, inspect

import atheist
from atheist.gvar import Log

class Loader(object):
    def __init__(self, dname):
        self.plugins = []
        for m in self.load_modules(dname):

            Log.debug("PluginManager: Loading module '%s'" % m.__file__)

            klases = [x[1] for x in inspect.getmembers(m, inspect.isclass)]
            if not klases:
                continue

            plugins = [x for x in klases
                       if issubclass(x, atheist.Task) or
                       issubclass(x, atheist.Condition)]

            self.plugins.extend(plugins)
            Log.debug("PluginManager: %s" % [x.__name__ for x in plugins])


    @staticmethod
    def load_modules(dname):
        files = [os.path.splitext(x)[0]  for x in os.listdir(dname)
                 if not x.startswith('.') and
                    not x.startswith('#') and
                    x.endswith('.py')]

        modules = []

        for f in files:
            fp, fpath, desc =  imp.find_module(f, [dname])
#            Log.debug("Module: %s %s" % (fpath, desc))
            try:
                modules.append(imp.load_module(f, fp, fpath, desc))
            finally:
                if fp: fp.close()

        return modules


    def __iter__(self):
        return iter(self.plugins)


