(*
** This is a verified implementation of a solution to the famous
** ferryman puzzle:
**
** A ferryman tries to move a cabbage, a goat and a wolf across
** a river; at the start, F, C, G and W are all on one side of the
** river, and at the finish, they will be all on the other side of
** the river. A correct solution must satisfy the following rules:
**
** F and at most one additional item can ferry across the river at
** one time; C and G cannot be on the same side unless F is also on
** that side; the same also applies to G and W.
*)

(* ****** ****** *)
//
// Author: Hongwei Xi (2012-05-05) // Cinco de Mayo :)
//
(* ****** ****** *)

absview
STATE0 ( // for all states
  f: bool, c: bool, g: bool, w: bool
) // end of [STATE0]

absview
STATE1 ( // for safe states
  f: bool, c: bool, g: bool, w: bool
) // end of [STATE1]

(* ****** ****** *)

stadef safecond1
  (f: bool, c: bool, g: bool) = (f == c || c != g)
stadef safecond2
  (f: bool, g: bool, w: bool) = (f == g || g != w)

(* ****** ****** *)

extern
praxi
stateTrans01
{
  f,c,g,w:bool
| safecond1 (f, c, g)
; safecond2 (f, g, w)
} (
  pf: !STATE0 (f, c, g, w) >> STATE1 (f, c, g, w)
) : void // end of [stateTrans01]

extern
praxi stateTrans10
  {f,c,g,w:bool} (
  pf: !STATE1 (f, c, g, w) >> STATE0 (f, c, g, w)
) : void // end of [stateTrans10]

(* ****** ****** *)

absvtype F (f:bool) = ptr
absvtype C (c:bool) = ptr
absvtype G (g:bool) = ptr
absvtype W (w:bool) = ptr

(* ****** ****** *)

fun F (): F (false) = $extval (F (false), "0")
fun C (): C (false) = $extval (C (false), "0")
fun G (): G (false) = $extval (G (false), "0")
fun W (): W (false) = $extval (W (false), "0")

extern praxi nF (f: F (true)): void
extern praxi nC (f: C (true)): void
extern praxi nG (f: G (true)): void
extern praxi nW (f: W (true)): void

(* ****** ****** *)

%{^

extern
atstype_int
printf (const char *fmt, ...) ;

atsvoid_t0ype
move_f (atstype_ptr f)
{
  printf ("move_f: ferryman alone\n") ; return ;
}
atsvoid_t0ype
move_fc (
  atstype_ptr f, atstype_ptr c
)
{
  printf ("move_fc: ferryman with cabbage\n") ; return ;
}
atsvoid_t0ype
move_fg (
  atstype_ptr f, atstype_ptr g
)
{
  printf ("move_fg: ferryman with goat\n") ; return ;
}
atsvoid_t0ype
move_fw (
  atstype_ptr f, atstype_ptr w
)
{
  printf ("move_fw: ferryman with wolf\n") ; return ;
}
%}

(* ****** ****** *)

extern
fun move_f
  {f,c,g,w:bool} (
  pf: !STATE1 (f, c, g, w) >> STATE0 (~f, c, g, w)
| f: !F(f) >> F(~f)
) : void = "mac#" // end of [move_f]

extern
fun move_fc
  {f,c,g,w:bool | f == c} (
  pf: !STATE1 (f, c, g, w) >> STATE0 (~f, ~c, g, w)
| f: !F(f) >> F(~f)
, c: !C(c) >> C(~c)
) : void = "mac#" // end of [move_fc]

extern
fun move_fg
  {f,c,g,w:bool | f == g} (
  pf: !STATE1 (f, c, g, w) >> STATE0 (~f, c, ~g, w)
| f: !F(f) >> F(~f)
, g: !G(g) >> G(~g)
) : void = "mac#" // end of [move_fg]

extern
fun move_fw
  {f,c,g,w:bool | f == w} (
  pf: !STATE1 (f, c, g, w) >> STATE0 (~f, c, g, ~w)
| f: !F(f) >> F(~f)
, w: !W(w) >> W(~w)
) : void = "mac#" // end of [move_fw]

(* ****** ****** *)

extern
fun solvePuzzle
(
  pf: !STATE0 (false, false, false, false) >> STATE0 (true, true, true, true)
| f: !F (false) >> F (true)
, c: !C (false) >> C (true)
, g: !G (false) >> G (true)
, w: !W (false) >> W (true)
) : void // end of [solvePuzzle]

(* ****** ****** *)

implement
solvePuzzle
  (pf | f, c, g, w) = let
  prval () = stateTrans01 (pf)
  val () = move_fg (pf | f, g)
  prval () = stateTrans01 (pf)
  val () = move_f (pf | f)
  prval () = stateTrans01 (pf)
  val () = move_fc (pf | f, c)
  prval () = stateTrans01 (pf)
  val () = move_fg (pf | f, g)
  prval () = stateTrans01 (pf)
  val () = move_fw (pf | f, w)
  prval () = stateTrans01 (pf)
  val () = move_f (pf | f)
  prval () = stateTrans01 (pf)
  val () = move_fg (pf | f, g)
in
  // nothing
end // end of [solvePuzzle]

(* ****** ****** *)

implement
main0 () = let
//
val f = F ()
val c = C ()
val g = G ()
val w = W ()
//
prval (
  pf, fpf
) = __assert () where
{
  extern
  praxi __assert : () -<prf>
    (STATE0 (false, false, false, false),  STATE0 (true, true, true, true) -<lin> void)
  // end of [extern]
}
//
val () = solvePuzzle (pf | f, c, g, w)
//
prval () = nF (f)
prval () = nC (c)
prval () = nG (g)
prval () = nW (w)
//
prval () = fpf (pf)
//
in
  // nothing  
end // end of [main0]

(* ****** ****** *)

(* end of [ferryman.dats] *)
