/****************************************************************
**
** Attal : Lords of Doom
**
** miniMap.h
** draw and manage the mini-map
**
** Version : $Id: miniMap.h,v 1.4 2004/06/15 21:32:30 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/12/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef MINIMAP_H
#define MINIMAP_H
 
 
// generic include files
// include files for QT
#include <qwidget.h>
#include <qpixmap.h>
// application specific include files
#include "libCommon/genericMap.h"

class GenericCell;

/*              ------------------------------
 *                         MiniMap
 *              ------------------------------ */



/** comment for the class */
class MiniMap : public QWidget
{

	Q_OBJECT
public:
	/** Constructor */
	MiniMap( GenericMap * map, QWidget * parent = 0, const char * name = 0 );

	/** Redraw the mini map */
	void redrawMap( GenericMap * map );

	/** Redraws the cell <i, j> */
	void redrawCell( GenericCell * cell );
	
	void redrawCellFast( GenericCell * cell );

	void resizeMap( uint width, uint height );

signals:

	void sig_mouseReleasedMinimap( GenericCell * cell );

protected:
	virtual void paintEvent( QPaintEvent * event );
	virtual void resizeEvent( QResizeEvent * event );
	virtual void mouseReleaseEvent( QMouseEvent * event );
	virtual void mousePressEvent( QMouseEvent * event );

private:
	QPixmap * _qp;
	GenericMap * _map;
	uint _height, _width;
	int _ntiles;
	uint _sizeH,_sizeV;
};

#endif // MINIMAP_H
