/****************************************************************
**
** Attal : Lords of Doom
**
** engine.h
** the game engine !
**
** Version : $Id: engine.h,v 1.26 2004/12/07 19:03:53 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 03/10/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef ENGINE_H
#define ENGINE_H


// generic include files
// include files for QT
#include <qobject.h>
#include <qptrlist.h>
// application specific includes
#include "libCommon/calendar.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericMap.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericPlayer.h"

#include "libServer/attalServer.h"
#include "libServer/fightEngine.h"
#include "libServer/gameData.h"

class Campaign;
class GenericBonus;
class GenericMapCreature;
class QuestionManager;
class ScenarioParser;

/*              ------------------------------
 *                         Engine
 *              ------------------------------ */


class Engine : public QObject, public GameData
{
	Q_OBJECT
public:
	/** Constructor */
	Engine( AttalServer * serv );

	/** Start game (scenario) */
	void startGame();
	
	/** Start game (scenario) */
	void startCampaign();

	/** Load a game (scenario) */
	bool loadGame( const QString & filename , bool silent);
	
	/** Load a game (scenario) */
	bool loadCampaign( const QString & filename );

	/** Save the game */
	bool saveGame( const QString & filename );

	/** End the game */
	void endGame();

	/** Start a fight */
	void startFight();
	void startFight( int lordAttack, GenericLord *lordDefense );
	void startFight( int lordAttack, GenericMapCreature * creature );

	/** End the fight */
	void endFight();

	/** Reinit game engine */
	void reinit();
	
	int getNumFillPlayers() { return _tmpPlay > 0 ? _tmpPlay : 0 ; }

	/** Activate the next player */
	void nextPlayer();
	
	void setFinished(bool finish) {_isFinished = finish;}

public slots:
	/** Slot who reads socket */
	void slot_readSocket( int );

	/** Slot for managing new players */
	void slot_newPlayer( AttalPlayerSocket * player );

	/** Slot for removing a player disconnected */
	void slot_endConnection( QString name );

	/** Slot catching end of fight */
	void slot_endFight( char result );

signals:
	void sig_newPlayer( AttalPlayerSocket * player );

private:
	enum CreatureAction {
		CreatureJoin,
		CreatureMercenary,
		CreatureFlee,
		CreatureFight
	};

	CreatureAction computeCreatureAction( GenericMapCreature * creature, double ratio );

	void checkMainQuest();

	void stateNotPlaying( int num );
	void stateInGame( int num );
	void stateInQuestion( uint num );
	void stateInFight( int num );

	void handleMessage();
	void handleAnswer();
	void handleInGameMvt( int num );
	void handleInGameExchange();
	void handleInGameModif();
	void handleInGameModifBase();
	void handleInGameModifLord();
	void handleInGameModifLordGarrison();
	void handleInGameModifLordUnit();
	void handleInGameTurn();

	void newDay();

	void handleAnswerCreatureJoin();
	void handleAnswerCreatureMercenary();
	void handleAnswerCreatureFlee();
	
	// enter into building (if return == true)
	bool handleBuildingEnter( GenericBuilding * building, GenericLord * lord );
	void handleBuildingAction( Action * action, GenericLord * lord );

	void handleCreatTurn( GenericPlayer * player, GenericLord * lord );
	void handleBaseTurn( GenericPlayer * player, GenericBase * base );
	void handleBuildingTurn( GenericPlayer * player, GenericBuilding * building );
	void handleBuildingAction( Action * action, GenericPlayer * player );

	bool handleOneMove( GenericLord * movingLord, GenericCell * destCell, int num );
	void movingOnLord( GenericLord * movingLord, GenericCell * destCell );
	void movingOnEvent( GenericLord * movingLord, GenericCell * destCell );
	void movingOnArtefact( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBonus( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBonusResource( GenericBonus * bonus );
	void movingOnBonusPrimSkill( GenericLord * movingLord, GenericBonus * bonus );
	void movingOnChest( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBuilding( GenericLord * movingLord, GenericCell * destCell, int num );
	void movingOnBase( GenericLord * movingLord, GenericCell * destCell, int num );
	void movingOnCreature( GenericLord * movingLord, GenericCell * destCell );
	void movingOnFreeCell( GenericLord * movingLord, GenericCell * destCell, int num );

	uint getAlivePlayersNumber();
	void exchangeUnits();
	void exchangeArtefact();
	void exchangeBaseUnits();
	bool enoughPlayers();

	int getRandResource( int coeff);
	void updatePlayerPrices( GenericPlayer * player);

	void updateMapVision( QPtrList<GenericCell> & removed, QPtrList<GenericCell> & added );
	void updateCellVision( GenericCell * cell );

	void manageIncreaseExperience( GenericLord * lord, uint experience );

	enum State {
		NOT_PLAYING,
		IN_GAME,
		IN_QUESTION,
		IN_FIGHT
	};

	bool _isCreature;
	bool _isFinished;
	int _tmpPlay;

	AttalServer * _server;
	FightEngine * _fight;
	State _state;
	GenericPlayer * _currentPlayer;
	Calendar * _calendar;
	int _counter;
	Campaign * _campaign;

	QuestionManager * _question;
};

#endif // ENGINE_H

















