#include <gtk/gtk.h>
#include <string.h>

#include "../config.h"
#include "plugin_dialogs.h"
#include "plugin_main.h"
#include "plugin_skin.h"

extern vumeter_window	plugin_win[MAX_INSTANCES];

extern GArray		*plugin_skin_data,
			*plugin_skin_list;

extern gint		num_of_windows,
			num_of_samples,
			target_fps,
			data_source,
			decay_pct,
			plugin_initialized,

			devmode_enabled;

extern float		devmode_left_value,
			devmode_right_value;

gint			tmp_num_of_samples,
			tmp_decay_pct,
			tmp_target_fps,
			tmp_skin_found;

GtkObject		*conf_hadj1,		// FPS
			*conf_hadj2,		// Averaging
			*conf_hadj3,		// Decay

			*dev_hadj1,		// Left channel
			*dev_hadj2;		// Right channel

GtkWidget		*aboutWin=NULL,
			*configWin=NULL,

			*conf_entry_1,
			*conf_entry_2,
			*conf_entry_3,

			*dev_entry_1,
			*dev_entry_2,

			*tmp_rb1,
			*tmp_rb2,
			*errorDialog=NULL;

GtkTreeSelection 	*tv_sel_1=NULL,
			*tv_sel_2=NULL;

GtkListStore		*tv_store_1=NULL,
			*tv_store_2=NULL;


/********************************************************************
 * Function to update window list to config window
 ********************************************************************/
void vumeter_wlist_select_first(void)
{
	GtkTreeIter	iter;

	if(gtk_tree_model_get_iter_first(GTK_TREE_MODEL(tv_store_1),&iter)==FALSE) 
		return;

	gtk_tree_selection_select_iter(tv_sel_1,&iter);
}

void vumeter_update_window_list(void)
{
	GtkTreeIter	tv_iter;
	int		i;

	// 
	if(configWin==NULL || tv_store_1==NULL)
	{
		return;
	}

	// Remove old
	gtk_list_store_clear (tv_store_1);
	
	// Fill information
	for(i=0; i<MAX_INSTANCES; i++)
	if(plugin_win[i].win!=NULL)
	{
		gtk_list_store_append(tv_store_1, &tv_iter);
		gtk_list_store_set (tv_store_1, &tv_iter, 0,i+1, -1);
	}
}

void vumeter_update_skin_list(void)
{
	GtkTreeIter	tv_iter;
	unsigned int	i;
	plugin_sl_el	*t_ptr;
	char		*t_txt;
	
	
	// 
	if(configWin==NULL || tv_store_2==NULL)
	{
		return;
	}

	// Remove old
	gtk_list_store_clear (tv_store_2);
	
	// Fill information
	for(i=0; i<plugin_skin_list->len; i++)
	{
		t_ptr = &g_array_index(plugin_skin_list,plugin_sl_el,i);

		gtk_list_store_append(tv_store_2, &tv_iter);
		if(t_ptr->pathnum == 1)	t_txt="local";
		else			t_txt="global";

		gtk_list_store_set (tv_store_2, &tv_iter, 0,t_txt, 1, t_ptr->dirname,-1);
	}
}

/********************************************************************
 * Functions to handle treeview row changes
 ********************************************************************/
gboolean vumeter_handle_tw_row_2_helper(GtkTreeModel *model,GtkTreeIter *iter,vumeter_skin *skin,gint slot_num)
{
	gint		path_num;
	gchar		*path_name,
			*skin_name;
	gboolean	retval = TRUE;

	gtk_tree_model_get(model,iter,0,&path_name,1,&skin_name,-1);

	if(strcasecmp("local",path_name)==0)		path_num=1;
	else						path_num=0;
	g_free(path_name);

	if(skin->pathnum != path_num) 			retval = FALSE;
	if(strcmp(skin->skin_name,skin_name)!=0)	retval = FALSE;

	// Reload skin, if window slot num is given
	if(slot_num>=0 && retval == FALSE)
		vumeter_change_window_skin(slot_num,path_num,skin_name);

	g_free(skin_name);
	return(retval);
}

gboolean vumeter_handle_tw_row_1_helper(GtkTreeModel *model,GtkTreePath *path,GtkTreeIter *iter,gpointer data)
{
	vumeter_window *ptr = (vumeter_window *)data;
	vumeter_skin   *skin;

	// Compare current skin to skin in list
	skin = &g_array_index(plugin_skin_data, vumeter_skin, ptr->skin_num-1);
	if(vumeter_handle_tw_row_2_helper(model,iter,skin,-1)==FALSE) 
	{
		return(FALSE);
	}

	// Skin found, break out of foreach loop
	tmp_skin_found=1;
	gtk_tree_selection_select_iter(tv_sel_2,iter);
	return(TRUE);
}

static void vumeter_handle_tw_row_1(GtkTreeSelection *sel, gpointer ptr)
{
	GtkTreeIter	iter;
	GtkTreeModel    *model;
	gint		slot_num=-1;

	// Disable treeview 2, if nothing has been selected
	if( gtk_tree_selection_count_selected_rows(tv_sel_1) < 1 )
	{
		gtk_tree_selection_set_mode (tv_sel_2 , GTK_SELECTION_NONE);
		return;
	}

	if( !gtk_tree_selection_get_selected(tv_sel_1,&model,&iter) ) return;

	// Get selected row
	gtk_tree_model_get(model,&iter,0,&slot_num,-1);
	slot_num--;

	// Select correct row from treeview 2
	tmp_skin_found=-1;
	gtk_tree_selection_set_mode (tv_sel_2 , GTK_SELECTION_SINGLE);
	gtk_tree_model_foreach(GTK_TREE_MODEL(tv_store_2),vumeter_handle_tw_row_1_helper,&plugin_win[slot_num]);

	// Remove selection, if skin was not found
	if(tmp_skin_found==-1)
		gtk_tree_selection_set_mode (tv_sel_2 , GTK_SELECTION_NONE);
}

static void vumeter_handle_tw_row_2(GtkTreeSelection *sel, gpointer ptr)
{
	GtkTreeIter	iter2,iter1;
	GtkTreeModel    *model2,*model1;
	gint 		slot_num=-1;
	vumeter_skin	*skin;

	// Get selected row from skin list
	if( gtk_tree_selection_count_selected_rows(tv_sel_2) !=1 ) return;
	if( !gtk_tree_selection_get_selected(tv_sel_2,&model2,&iter2) )	return;

	// Get selected row from window list
	if( gtk_tree_selection_count_selected_rows(tv_sel_1) !=1 ) return;
	if( !gtk_tree_selection_get_selected(tv_sel_1,&model1,&iter1) ) return;

	// Do nothing, if current skin is selected
	gtk_tree_model_get(model1,&iter1,0,&slot_num,-1);
	
	skin = &g_array_index(plugin_skin_data, vumeter_skin, plugin_win[slot_num-1].skin_num-1);
	vumeter_handle_tw_row_2_helper(model2,&iter2,skin,slot_num-1);
}

/********************************************************************
 * Function to handle buttons
 ********************************************************************/
void dialogHandleResponse (GtkWidget *widget, gint rid, gpointer data)
{
	if(rid == GTK_RESPONSE_CLOSE || rid == GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(widget);
	} 
}

static void vumeter_handle_button_1(GtkWidget *widget, gpointer ptr)
{
	int		i,snum;
	GtkWidget	*dialog;

	// Can't create more instances :/
	if(num_of_windows>=MAX_INSTANCES)
	{
		dialog=gtk_message_dialog_new (GTK_WINDOW(configWin),
						GTK_DIALOG_DESTROY_WITH_PARENT,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,
						"Can't create more instances\nLimit = %d",MAX_INSTANCES);
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		return;
	}

	// Create new window
	for(i=0; i<MAX_INSTANCES; i++)
	if(plugin_win[i].win==NULL)
	{
		snum = vumeter_load_skin(	g_array_index(plugin_skin_list, plugin_sl_el, 0).pathnum,
						g_array_index(plugin_skin_list, plugin_sl_el, 0).dirname);

		if(vumeter_create_window(i,snum)==NULL)
		{
			// TODO (add error dialog)
			printf("VUMETER: Critical error while creating windows!\n");
			return;
		} 

		num_of_windows++;
		return;
	}
}

static void vumeter_handle_button_2(GtkWidget *widget, gpointer ptr)
{
	GtkTreeIter	iter;
	GtkTreeModel    *model;
	GtkWidget	*dialog;
	gint		value=-1;

	// Do nothing if no rows have been selected
	if( gtk_tree_selection_count_selected_rows(tv_sel_1) !=1 )
		return;

	// Get selected row
	if( gtk_tree_selection_get_selected(tv_sel_1,&model,&iter) )
	{
		gtk_tree_model_get(model,&iter,0,&value,-1);
		value--;
	}

	if(value>=0)
	{
		if(num_of_windows==1)
		{
			dialog=gtk_message_dialog_new (GTK_WINDOW(configWin),
							GTK_DIALOG_DESTROY_WITH_PARENT,GTK_MESSAGE_ERROR,
							GTK_BUTTONS_CLOSE,
							"This is the last window, please disable\nplugin instead, if you wish to close it");
			gtk_dialog_run (GTK_DIALOG (dialog));
			gtk_widget_destroy (dialog);
			return;
		}

		gtk_object_destroy( GTK_OBJECT(plugin_win[value].win) );
	}
}

// Refresh skin list
static void vumeter_handle_button_3(GtkWidget *widget, gpointer ptr)
{
	// Rescan skin directories
	vumeter_scan_skin_dirs();

	// Repopulate skin list
	vumeter_update_skin_list();

	// Reselect the current skin.. if any
	vumeter_handle_tw_row_1(NULL,NULL);
}

// Apply changes
static void vumeter_handle_button_4(GtkWidget *widget, gpointer ptr)
{
	target_fps	= tmp_target_fps;
	num_of_samples	= tmp_num_of_samples;
	decay_pct	= tmp_decay_pct;

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tmp_rb1))==TRUE)	data_source=1;
	else									data_source=2;
}

// Reset values
static void vumeter_handle_button_5(GtkWidget *widget, gpointer ptr)
{
	char tmp[30];

	tmp_target_fps		= target_fps;
	snprintf(tmp,30,"%d",target_fps);
	gtk_entry_set_text(GTK_ENTRY(conf_entry_1),tmp);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(conf_hadj1),(gdouble)target_fps);

	tmp_num_of_samples	= num_of_samples;
	snprintf(tmp,30,"%d",num_of_samples);
	gtk_entry_set_text(GTK_ENTRY(conf_entry_2),tmp);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(conf_hadj2),(gdouble)num_of_samples);

	tmp_decay_pct		= decay_pct;
	snprintf(tmp,30,"%d",decay_pct);
	gtk_entry_set_text(GTK_ENTRY(conf_entry_3),tmp);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(conf_hadj3),(gdouble)decay_pct);

	if(data_source==1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp_rb1),TRUE);
	if(data_source==2)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp_rb2),TRUE);
}


/********************************************************************
 * Functions to handle hscale adjustments
 ********************************************************************/
static void vumeter_handle_hscale_adj(GtkAdjustment *adj,gpointer data)
{
	int	value1; 
	float	value2;
	char	tmp1[30],
		tmp2[30];

	if( adj->value >= 0.0)	value1 = (int)(adj->value+0.5);
	else			value1 = (int)(adj->value-0.5);

	value2 = adj->value;

	snprintf(tmp1,30,"%d",value1);
	snprintf(tmp2,30,"%.01f",value2);

	if(data == conf_hadj1)
	{
		gtk_entry_set_text(GTK_ENTRY(conf_entry_1),tmp1);
		tmp_target_fps = value1;
	} else if( data == conf_hadj2 ) {
		gtk_entry_set_text(GTK_ENTRY(conf_entry_2),tmp1);
		tmp_num_of_samples = value1;
	} else if( data == conf_hadj3 ) {
		gtk_entry_set_text(GTK_ENTRY(conf_entry_3),tmp1);
		tmp_decay_pct = value1;
	} else if( data == dev_hadj1 ) {
		gtk_entry_set_text(GTK_ENTRY(dev_entry_1),tmp2);
		devmode_left_value = value2;
	} else if( data == dev_hadj2 ) {
		gtk_entry_set_text(GTK_ENTRY(dev_entry_2),tmp2);
		devmode_right_value = value2;
	}
}

static void vumeter_handle_checkbox(GtkToggleButton *btn,gpointer data)
{
	if(btn->active==TRUE)
	{
		devmode_enabled=1;
	} else {
		devmode_enabled=0;
	}
}

/********************************************************************
 * Error dialog functions
 ********************************************************************/
void vumeter_error_dialog(char *message)
{
	// Create error dialog
	errorDialog = gtk_message_dialog_new(NULL,0,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"%s",message);

	// Clicking 'CLOSE'-button causes either CANCEL or CLOSE response event
	gtk_signal_connect( GTK_OBJECT(errorDialog), "response", GTK_SIGNAL_FUNC(dialogHandleResponse), 
	                    NULL );

	// This sets aboutWin to NULL for us
	gtk_signal_connect( GTK_OBJECT(errorDialog), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), 
	                    &aboutWin);

	gtk_widget_show(errorDialog);
}

/********************************************************************
 * About dialog functions
 ********************************************************************/
void vumeter_about(void)
{
	// Does about dialog already exist?	
	if(aboutWin!=NULL) return;

	// Create new dialog
	aboutWin = gtk_about_dialog_new();

	// Clicking 'CLOSE'-button causes either CANCEL or CLOSE response event
	gtk_signal_connect( GTK_OBJECT(aboutWin), "response", GTK_SIGNAL_FUNC(dialogHandleResponse), 
	                    NULL );

	// This sets aboutWin to NULL for us
	gtk_signal_connect( GTK_OBJECT(aboutWin), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), 
	                    &aboutWin);

	// Set dialogs data
	gtk_about_dialog_set_name (	GTK_ABOUT_DIALOG(aboutWin), PACKAGE_NAME);
	gtk_about_dialog_set_version (	GTK_ABOUT_DIALOG(aboutWin), PACKAGE_VERSION);
	gtk_about_dialog_set_website (	GTK_ABOUT_DIALOG(aboutWin), "http://vumeterplugin.sourceforge.net/");

	// show the darn widget
	gtk_widget_show(aboutWin);
}

/********************************************************************
 * Configure dialog functions
 ********************************************************************/
void vumeter_config(void)
{
	char		tmp_txt[30];
	GtkWidget	*notebook,
			*tmp_label,
			*tmp_frame1,
			*tmp_frame2,
			*tmp_table,
			*tmp_vbox,
			*tmp_hbox,
			*tmp_swin_1,
			*tmp_swin_2,
			*tmp_button,
                        *treeview_1,
			*treeview_2,
			*tmp_hbar,
			*tmp_cbox;

	GSList 		*btn_group;

	GtkCellRenderer *tv_rend_1,
			*tv_rend_2;

	// Does config window already exist?	
	if(configWin!=NULL) return;
	
	// Causes segfault otherwise :/
	if(plugin_initialized==0) return;

	// Set temp values
	tmp_num_of_samples = num_of_samples;
	tmp_target_fps	   = target_fps;
	tmp_decay_pct      = decay_pct;

	// -- Main window
	configWin = gtk_window_new (GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title(GTK_WINDOW(configWin), "Analog VU meter Configuration");
	gtk_window_set_resizable ( GTK_WINDOW(configWin), TRUE );
	gtk_window_set_type_hint ( GTK_WINDOW (configWin), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_container_set_border_width(GTK_CONTAINER(configWin),5);
        gtk_widget_set_usize (configWin, 600 , 300);

	gtk_signal_connect(GTK_OBJECT(configWin), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configWin);

	// -- Notebook
	notebook = gtk_notebook_new();
	gtk_container_add (GTK_CONTAINER (configWin), notebook);

	// -----------------------------------------------------
	// --  Page 1
	// -----------------------------------------------------
	tmp_label  = gtk_label_new ("Window management");

	tmp_vbox   = gtk_vbox_new(FALSE,0);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tmp_vbox, tmp_label);

	tmp_swin_1 = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(tmp_swin_1),5);
	tmp_frame1 = gtk_frame_new ("Plugin windows");
        gtk_container_add(GTK_CONTAINER(tmp_frame1), GTK_WIDGET(tmp_swin_1));

	tmp_swin_2 = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(tmp_swin_2),5);
	tmp_frame2 = gtk_frame_new ("Available skins");
        gtk_container_add(GTK_CONTAINER(tmp_frame2), GTK_WIDGET(tmp_swin_2));

	tmp_hbox   = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_frame1, FALSE, TRUE, 4);
	gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_frame2, TRUE, TRUE, 4);

	gtk_box_pack_start (GTK_BOX (tmp_vbox), tmp_hbox, TRUE, TRUE, 4);

	tmp_hbox   = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start (GTK_BOX (tmp_vbox), tmp_hbox, FALSE, TRUE, 4);

	tmp_button = gtk_button_new_with_label("Add window");
	gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_button, FALSE, TRUE, 4);
	gtk_signal_connect(GTK_OBJECT(tmp_button), "clicked", GTK_SIGNAL_FUNC(vumeter_handle_button_1), NULL);

	tmp_button = gtk_button_new_with_label("Close window");
	gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_button, FALSE, TRUE, 4);
	gtk_signal_connect(GTK_OBJECT(tmp_button), "clicked", GTK_SIGNAL_FUNC(vumeter_handle_button_2), NULL);

	gtk_box_pack_start (GTK_BOX (tmp_hbox), gtk_vbox_new(FALSE,0), TRUE, TRUE, 4);

	tmp_button = gtk_button_new_with_label("Refresh skin list");
	gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_button, FALSE, TRUE, 4);
	gtk_signal_connect(GTK_OBJECT(tmp_button), "clicked", GTK_SIGNAL_FUNC(vumeter_handle_button_3), NULL);

	// Show all Plugin windows 
        treeview_1 = gtk_tree_view_new ();
		tv_sel_1 = gtk_tree_view_get_selection ( GTK_TREE_VIEW (treeview_1) );
		gtk_tree_selection_set_mode (tv_sel_1 , GTK_SELECTION_SINGLE);

		tv_rend_1 = gtk_cell_renderer_text_new ();
		gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview_1),-1,
								"Slot",tv_rend_1,
								"text",0,NULL);

		tv_store_1 = gtk_list_store_new (1, G_TYPE_UINT);
		gtk_tree_view_set_model (GTK_TREE_VIEW (treeview_1),GTK_TREE_MODEL(tv_store_1));
		g_object_unref (tv_store_1);

		gtk_container_add(GTK_CONTAINER(tmp_swin_1), GTK_WIDGET(treeview_1));
		g_signal_connect( G_OBJECT(tv_sel_1), "changed", G_CALLBACK(vumeter_handle_tw_row_1), NULL);

		vumeter_update_window_list();

	// Show available skins 
        treeview_2 = gtk_tree_view_new ();
		tv_sel_2 = gtk_tree_view_get_selection ( GTK_TREE_VIEW (treeview_2) );
		gtk_tree_selection_set_mode (tv_sel_2 , GTK_SELECTION_SINGLE);

		tv_rend_2 = gtk_cell_renderer_text_new ();
		gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview_2),-1,
								"Dir",tv_rend_2,
								"text",0,NULL);

		tv_rend_2 = gtk_cell_renderer_text_new ();
		gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview_2),-1,
								"Name",tv_rend_2,
								"text",1,NULL);

		tv_store_2 = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
		gtk_tree_view_set_model (GTK_TREE_VIEW (treeview_2),GTK_TREE_MODEL(tv_store_2));
		g_object_unref (tv_store_2);

		gtk_container_add(GTK_CONTAINER(tmp_swin_2), GTK_WIDGET(treeview_2));
		g_signal_connect( G_OBJECT(tv_sel_2), "changed", G_CALLBACK(vumeter_handle_tw_row_2), NULL);

		vumeter_update_skin_list();
	
	// Select first window from list
	vumeter_wlist_select_first();

	// -----------------------------------------------------
	// --  Page 2
	// -----------------------------------------------------
	tmp_label = gtk_label_new ("Preferences");
	tmp_table = gtk_table_new (5,3,FALSE);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tmp_table, tmp_label);

	tmp_label  = gtk_label_new ("FPS");
	gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);

	conf_hadj1  = gtk_adjustment_new(target_fps,25,50,1,5,0);
	tmp_hbar   = gtk_hscale_new(GTK_ADJUSTMENT(conf_hadj1));
	gtk_scale_set_digits(GTK_SCALE(tmp_hbar),0);
	gtk_scale_set_draw_value(GTK_SCALE(tmp_hbar),FALSE);

	conf_entry_1= gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(conf_entry_1),2);
	gtk_entry_set_editable   (GTK_ENTRY(conf_entry_1),FALSE);
	snprintf(tmp_txt,30,"%d",target_fps);
	gtk_entry_set_text(GTK_ENTRY(conf_entry_1),tmp_txt);

		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label  ,0,1,0,1,            GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbar   ,1,2,0,1, GTK_EXPAND|GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),conf_entry_1,2,3,0,1,                   0,0, 10,10);

	gtk_signal_connect(GTK_OBJECT(conf_hadj1),"value_changed",GTK_SIGNAL_FUNC(vumeter_handle_hscale_adj),conf_hadj1);

	//
	tmp_label  = gtk_label_new ("Averaging");
	  gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);

	conf_hadj2  = gtk_adjustment_new(num_of_samples,1,10,1,2,0);
	tmp_hbar   = gtk_hscale_new(GTK_ADJUSTMENT(conf_hadj2));
	  gtk_scale_set_digits(GTK_SCALE(tmp_hbar),0);
	  gtk_scale_set_draw_value(GTK_SCALE(tmp_hbar),FALSE);

	conf_entry_2= gtk_entry_new();
	  gtk_entry_set_width_chars(GTK_ENTRY(conf_entry_2),2);
	  gtk_entry_set_editable   (GTK_ENTRY(conf_entry_2),FALSE);
	  snprintf(tmp_txt,30,"%d",num_of_samples);
	  gtk_entry_set_text(GTK_ENTRY(conf_entry_2),tmp_txt);

		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label   ,0,1,1,2,            GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbar    ,1,2,1,2, GTK_EXPAND|GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),conf_entry_2,2,3,1,2,                   0,0, 10,10);

	gtk_signal_connect(GTK_OBJECT(conf_hadj2),"value_changed",GTK_SIGNAL_FUNC(vumeter_handle_hscale_adj),conf_hadj2);

	//
	tmp_label  = gtk_label_new ("Decay PCT");
	  gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);

	conf_hadj3  = gtk_adjustment_new(decay_pct,1,90,1,10,0);
	tmp_hbar   = gtk_hscale_new(GTK_ADJUSTMENT(conf_hadj3));
	  gtk_scale_set_digits(GTK_SCALE(tmp_hbar),0);
	  gtk_scale_set_draw_value(GTK_SCALE(tmp_hbar),FALSE);

	conf_entry_3= gtk_entry_new();
	  gtk_entry_set_width_chars(GTK_ENTRY(conf_entry_3),2);
	  gtk_entry_set_editable   (GTK_ENTRY(conf_entry_3),FALSE);
	  snprintf(tmp_txt,30,"%d",decay_pct);
	  gtk_entry_set_text(GTK_ENTRY(conf_entry_3),tmp_txt);

		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label   ,0,1,2,3,            GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbar    ,1,2,2,3, GTK_EXPAND|GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),conf_entry_3,2,3,2,3,                   0,0, 10,10);

	gtk_signal_connect(GTK_OBJECT(conf_hadj3),"value_changed",GTK_SIGNAL_FUNC(vumeter_handle_hscale_adj),conf_hadj3);

	//
	tmp_hbox   = gtk_hbox_new(FALSE,0);
	tmp_label  = gtk_label_new ("Use");
	  gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);

	tmp_rb1    = gtk_radio_button_new_with_label (NULL, "RMS-values");
	btn_group  = gtk_radio_button_get_group (GTK_RADIO_BUTTON (tmp_rb1));
	tmp_rb2    = gtk_radio_button_new_with_label (btn_group, "Peak-values");

	if(data_source==1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp_rb1),TRUE);
	if(data_source==2)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp_rb2),TRUE);

		gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_rb1, FALSE, TRUE, 4);
		gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_rb2, FALSE, TRUE, 4);

		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label  ,0,1,3,4,            GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbox   ,1,3,3,4,            GTK_FILL,0, 10,10);


	// 
	tmp_hbox   = gtk_hbox_new(FALSE,0);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbox  ,0,2,4,5,            GTK_FILL,0, 10,10);
	tmp_button = gtk_button_new_with_label("Apply changes");
		gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_button, FALSE, TRUE, 4);
		gtk_signal_connect(GTK_OBJECT(tmp_button), "clicked", 
				GTK_SIGNAL_FUNC(vumeter_handle_button_4), NULL);
	tmp_button = gtk_button_new_with_label("Reset values");
		gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_button, FALSE, TRUE, 4);
		gtk_signal_connect(GTK_OBJECT(tmp_button), "clicked", 
				GTK_SIGNAL_FUNC(vumeter_handle_button_5), NULL);


	// -----------------------------------------------------
	// --  Page 3
	// -----------------------------------------------------
	tmp_label = gtk_label_new ("Devel tools");
	tmp_table = gtk_table_new (4,3,FALSE);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tmp_table, tmp_label);

	//
	tmp_label  = gtk_label_new ("Enabled");
	gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label   ,0,1,0,1,            GTK_FILL,0, 10,10);

	tmp_cbox   = gtk_check_button_new();
	tmp_label  = gtk_label_new ("");
	tmp_hbox   = gtk_hbox_new(FALSE,0);

		gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_cbox, FALSE, TRUE, 4);
		gtk_box_pack_start (GTK_BOX (tmp_hbox), tmp_label, FALSE, TRUE, 4);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbox    ,1,3,0,1,            GTK_FILL,0, 10,10);
	
	if(devmode_enabled==1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp_cbox),TRUE);

	//
	tmp_label  = gtk_label_new ("Left");
	gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);

	dev_hadj1  = gtk_adjustment_new(devmode_left_value,-100,0,1,5,0);
	tmp_hbar   = gtk_hscale_new(GTK_ADJUSTMENT(dev_hadj1));
	gtk_scale_set_digits(GTK_SCALE(tmp_hbar),0);
	gtk_scale_set_draw_value(GTK_SCALE(tmp_hbar),FALSE);

	dev_entry_1= gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(dev_entry_1),5);
	gtk_entry_set_editable   (GTK_ENTRY(dev_entry_1),FALSE);
	snprintf(tmp_txt,30,"%.01f",devmode_left_value);
	gtk_entry_set_text(GTK_ENTRY(dev_entry_1),tmp_txt);

		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label   ,0,1,1,2,            GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbar    ,1,2,1,2, GTK_EXPAND|GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),dev_entry_1 ,2,3,1,2,                   0,0, 10,10);

	gtk_signal_connect(GTK_OBJECT(tmp_cbox),"toggled",GTK_SIGNAL_FUNC(vumeter_handle_checkbox),NULL);
	gtk_signal_connect(GTK_OBJECT(dev_hadj1),"value_changed",GTK_SIGNAL_FUNC(vumeter_handle_hscale_adj),dev_hadj1);

	//
	tmp_label  = gtk_label_new ("Right");
	gtk_misc_set_alignment(GTK_MISC(tmp_label),1.0,1.0);

	dev_hadj2  = gtk_adjustment_new(devmode_right_value,-100,0,1,5,0);
	tmp_hbar   = gtk_hscale_new(GTK_ADJUSTMENT(dev_hadj2));
	gtk_scale_set_digits(GTK_SCALE(tmp_hbar),0);
	gtk_scale_set_draw_value(GTK_SCALE(tmp_hbar),FALSE);

	dev_entry_2= gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(dev_entry_2),5);
	gtk_entry_set_editable   (GTK_ENTRY(dev_entry_2),FALSE);
	snprintf(tmp_txt,30,"%.01f",devmode_right_value);
	gtk_entry_set_text(GTK_ENTRY(dev_entry_2),tmp_txt);

		gtk_table_attach(GTK_TABLE(tmp_table),tmp_label   ,0,1,2,3,            GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),tmp_hbar    ,1,2,2,3, GTK_EXPAND|GTK_FILL,0, 10,10);
		gtk_table_attach(GTK_TABLE(tmp_table),dev_entry_2 ,2,3,2,3,                   0,0, 10,10);

	gtk_signal_connect(GTK_OBJECT(dev_hadj2),"value_changed",GTK_SIGNAL_FUNC(vumeter_handle_hscale_adj),dev_hadj2);

	// -----------------------------------------------------
	// --  Show all widgets
	// -----------------------------------------------------
	gtk_widget_show_all (configWin);
}
