/*
 * autotrust.h -library for automated updates of DNSSEC Trust Anchors (RFC5011).
 * Copyright (c) 2008, NLnet Labs. All rights reserved.
 * This software is open source.
 * For license see doc/LICENSE.
 */

#ifndef AUTOTRUST_H
#define AUTOTRUST_H

#include <config.h>

#include "src/log.h"
#include "src/options.h"
#include "src/resolver.h"
#include "src/trust_anchors.h"

/** Structure holding global settings for the autotrust program */
typedef struct autotrust_struct autotrust_t;
struct autotrust_struct {
	/* name of environment */
	const char*	env_name;
	/* configuration file */
	const char*	configfile;
	/* all the configuration options */
	options_t*	options;
	/* our set of trust points */
	tp_set_t*	trustpoints;
	/* flag to be set if trust anchors have become valid/invalid */
	uint8_t changed;
	/* signal received, quit program */
	volatile uint8_t sig_quit;
};

#endif /* AUTOTRUST_H */
