/* Test of _SFR's macroses.  Default usage.
   $Id: sfrasm-1.S,v 1.1.2.2 2008/05/02 08:47:37 dmix Exp $	*/

#include <avr/io.h>

#if	defined (__AVR_AT90S8515__)

# if	 SREG != 0x5F			\
     ||  _SFR_ADDR (SREG) != 0x5F	\
     ||	 _SFR_MEM_ADDR (SREG) != 0x5F	\
     ||	 _SFR_IO_ADDR (SREG) != 0x3F	\
     ||	 !_SFR_IO_REG_P (SREG)
#  error
# endif

# if	 WDTCR != 0x41			\
     ||	 _SFR_ADDR (WDTCR) != 0x41	\
     ||  _SFR_MEM_ADDR (WDTCR) != 0x41	\
     ||  _SFR_IO_ADDR (WDTCR) != 0x21	\
     ||	 !_SFR_IO_REG_P (WDTCR)
#  error
# endif

# if	 EEARH != 0x3F			\
     ||  _SFR_ADDR (EEARH) != 0x3F	\
     ||  _SFR_MEM_ADDR (EEARH) != 0x3F	\
     ||  _SFR_IO_ADDR (EEARH) != 0x1F	\
     ||  !_SFR_IO_REG_P (EEARH)
#  error
# endif

# if	 ACSR != 0x28			\
     ||  _SFR_ADDR (ACSR) != 0x28	\
     ||  _SFR_MEM_ADDR (ACSR) != 0x28	\
     ||  _SFR_IO_ADDR (ACSR) != 0x08	\
     ||  !_SFR_IO_REG_P (ACSR)
#  error
# endif

#elif	defined (__AVR_ATmega8__)

# if	 SREG != 0x5F			\
     ||  _SFR_ADDR (SREG) != 0x5F	\
     ||  _SFR_MEM_ADDR (SREG) != 0x5F	\
     ||  _SFR_IO_ADDR (SREG) != 0x3F	\
     ||  !_SFR_IO_REG_P (SREG)
#  error
# endif

# if	 UCSRC != 0x40			\
     ||  _SFR_ADDR (UCSRC) != 0x40	\
     ||  _SFR_MEM_ADDR (UCSRC) != 0x40	\
     ||  _SFR_IO_ADDR (UCSRC) != 0x20	\
     ||  !_SFR_IO_REG_P (UCSRC)
#  error
# endif

# if	 EEARH != 0x3F			\
     ||  _SFR_ADDR (EEARH) != 0x3F	\
     ||  _SFR_MEM_ADDR (EEARH) != 0x3F	\
     ||  _SFR_IO_ADDR (EEARH) != 0x1F	\
     ||  !_SFR_IO_REG_P (EEARH)
#  error
# endif

# if	 TWBR != 0x20			\
     ||  _SFR_ADDR (TWBR) != 0x20	\
     ||  _SFR_MEM_ADDR (TWBR) != 0x20	\
     ||  _SFR_IO_ADDR (TWBR) != 0x00	\
     ||  !_SFR_IO_REG_P (TWBR)
#  error
# endif

#elif	defined (__AVR_ATmega128__)

# if	 UCSR1C != 0x9D			\
     ||  _SFR_ADDR (UCSR1C) != 0x9D	\
     ||  _SFR_MEM_ADDR (UCSR1C) != 0x9D	\
     ||  _SFR_IO_REG_P (UCSR1C)
#  error
# endif

# if	 DDRF != 0x61			\
     ||  _SFR_ADDR (DDRF) != 0x61	\
     ||  _SFR_MEM_ADDR (DDRF) != 0x61	\
     ||  _SFR_IO_REG_P (DDRF)
#  error
# endif

# if	 SREG != 0x5F			\
     ||  _SFR_ADDR (SREG) != 0x5F	\
     ||  _SFR_MEM_ADDR (SREG) != 0x5F	\
     ||  _SFR_IO_ADDR (SREG) != 0x3F	\
     ||  !_SFR_IO_REG_P (SREG)
#  error
# endif

# if	 SFIOR != 0x40			\
     ||  _SFR_ADDR (SFIOR) != 0x40	\
     ||  _SFR_MEM_ADDR (SFIOR) != 0x40	\
     ||  _SFR_IO_ADDR (SFIOR) != 0x20	\
     ||  !_SFR_IO_REG_P (SFIOR)
#  error
# endif

# if	 EEARH != 0x3F			\
     ||  _SFR_ADDR (EEARH) != 0x3F	\
     ||  _SFR_MEM_ADDR (EEARH) != 0x3F	\
     ||  _SFR_IO_ADDR (EEARH) != 0x1F	\
     ||  !_SFR_IO_REG_P (EEARH)
#  error
# endif

# if	 PINF != 0x20			\
     ||  _SFR_ADDR (PINF) != 0x20	\
     ||  _SFR_MEM_ADDR (PINF) != 0x20	\
     ||  _SFR_IO_ADDR (PINF) != 0x00	\
     ||  !_SFR_IO_REG_P (PINF)
#  error
# endif

#endif


.macro	EXIT	result
	ldi	r24, lo8 (\result)
	ldi	r25, hi8 (\result)
	rjmp	exit
.endm

	.text
	.global	main
main:
	sei
	lds	r16, SREG
	sbrc	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	cli
	lds	r16, SREG
	sbrs	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	sei
	lds	r16, _SFR_ADDR (SREG)
	sbrc	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	cli
	lds	r16, _SFR_ADDR (SREG)
	sbrs	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	sei
	lds	r16, _SFR_MEM_ADDR (SREG)
	sbrc	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	cli
	lds	r16, _SFR_MEM_ADDR (SREG)
	sbrs	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	sei
	in	r16, _SFR_IO_ADDR (SREG)
	sbrc	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	cli
	in	r16, _SFR_IO_ADDR (SREG)
	sbrs	r16, SREG_I
	rjmp	0f
	EXIT	__LINE__

0:	EXIT	0
	.end
