/* Min and max float values.
   $Id: dtostrf-minmax.c,v 1.1 2007/02/06 12:36:58 dmix Exp $
 */
#include <stdlib.h>
#include <string.h>
#include "progmem.h"

#define PATTERN_SIZE	50
#include "dtostrf.h"

PROGMEM static const struct dtostrf_s t[] = {

    { { 0x00800000 }, 0, 45,
	"0.000000000000000000000000000000000000011754944"	},
    { { 0x00800000 }, 0, 44,
	"0.00000000000000000000000000000000000001175494"	},
    { { 0x00800000 }, 0, 43,
	"0.0000000000000000000000000000000000000117549"	},
    { { 0x00800000 }, 0, 42,
	"0.000000000000000000000000000000000000011755"	},
    { { 0x00800000 }, 0, 41,
	"0.00000000000000000000000000000000000001175"	},
    { { 0x00800000 }, 0, 40,
	"0.0000000000000000000000000000000000000118"	},
    { { 0x00800000 }, 0, 39,
	"0.000000000000000000000000000000000000012"	},
    { { 0x00800000 }, 0, 38,
	"0.00000000000000000000000000000000000001"	},
    { { 0x00800000 }, 0, 37,
	"0.0000000000000000000000000000000000000"	},
    { { 0x00800000 }, 0, 36,
	"0.000000000000000000000000000000000000"	},

    { { 0x80800000 }, 0, 45,
	"-0.000000000000000000000000000000000000011754944"	},
    { { 0x00800000 }, 49, 45,
	"  0.000000000000000000000000000000000000011754944"	},
    { { 0x80800000 }, 49, 45,
	" -0.000000000000000000000000000000000000011754944"	},

#ifdef	__AVR__		/* Reason: Glibc calculate all digits.	*/
    { { 0x7f7fffff }, 0, 0,
	"340282350000000000000000000000000000000" },
    { { 0xff7fffff }, 0, 0,
	"-340282350000000000000000000000000000000" },
#endif

};

int main ()
{
    int i;
    for (i= 0; (size_t)i != sizeof(t)/sizeof(t[0]); i++)
	run_dtostrf (t+i, i+1);
    return 0;
}
