/*
    AWFFull - A Webalizer Fork, Full o' features
    
    $Id: awffull.h 265 2006-08-27 05:06:10Z steve $

    Copyright (C) 1997-2001  Bradford L. Barrett (brad@mrunix.net)
    Copyright 2002, 2004 by Stanislaw Yurievich Pusep
    Copyright (C) 2004, 2005, 2006 by Stephen McInerney (spm@stedee.id.au)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

    This software uses the gd graphics library, which is copyright by
    Quest Protein Database Center, Cold Spring Harbor Labs.  Please
    see the documentation supplied with the library for additional
    information and license terms, or visit www.boutell.com/gd/ for the
    most recent version of the library and supporting documentation.
*/

#ifndef AWFFULL_AWFFULL_H
#define AWFFULL_AWFFULL_H


#include "common.h"

/* Internationalisation stuff */
#include <libintl.h>
#include <locale.h>
#include "gettext.h"

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)


#define FILENAME_CONFIG     "awffull.conf"
#define FILENAME_HISTORY    "awffull.hist"
#define FILENAME_CURRENT    "awffull.current"
#define FILENAME_CSS        "awffull.css"

#define SITE_ADDRESS        "http://www.stedee.id.au/awffull/"

#define GEOIP_DATABASE      "/usr/local/share/GeoIP/GeoIP.dat"

#define DATE_TIME_FORMAT "%d/%b/%Y:%H:%M:%S"    /* Default DATE_TIME format for input to strptime */
#define DATE_TIME_XFERLOG_FORMAT "%a %b %d %H:%M:%S %Y"

#define MAXHASH  5381                           /* Size of our hash tables          */
#define BUFSIZE  (1024 * 64)                    /* Max buffer size for log record   */
#define MAXHOST  256                            /* Max hostname buffer size         */
#define MAXURL   4096                           /* Max HTTP request/URL field size  */
#define MAXURLH  MAXURL                         /* Max URL field size in htab       */
#define MAXREF   4096                           /* Max referrer field size          */
#define MAXREFH  MAXREF                         /* Max referrer field size in htab  */
#define MAXAGENT 1024                           /* Max user agent field size        */
#define MAXCTRY  48                             /* Max country name size            */
#define MAXSRCH  1024                           /* Max size of search string buffer */
#define MAXSRCHH MAXSRCH                        /* Max size of search str in htab   */
#define MAXIDENT 64                             /* Max size of ident string (user)  */
#define MAXHISTLEN (20 * 12)                    /* Maximum length of the history - 20 years */

#define SLOP_VAL 3600                           /* out of sequence slop (seconds)   */


/* Default Graph Sizes */
#define GRAPH_INDEX_X 512                       /* px. Default X size (512)             */
#define GRAPH_INDEX_Y 256                       /* px. Default Y size (256)             */
#define GRAPH_DAILY_X 512                       /* px. Daily X size (512)               */
#define GRAPH_DAILY_Y 400                       /* px. Daily Y size (400)               */
#define GRAPH_HOURLY_X 512                      /* px. Daily X size (512)               */
#define GRAPH_HOURLY_Y 400                      /* px. Daily Y size (400)               */
#define GRAPH_PIE_X 512                         /* px. Pie X size (512)                 */
#define GRAPH_PIE_Y 300                         /* px. Pie Y size (300)                 */

/* Log types */
#define LOG_UNRECOGNISED -1                     /* Unrecognised log format              */
#define LOG_AUTO     0                          /* Try and discover the log format      */
#define LOG_CLF      1                          /* CLF log type                         */
#define LOG_FTP      2                          /* wu-ftpd xferlog type                 */
#define LOG_SQUID    3                          /* squid proxy log                      */
#define LOG_COMBINED 4                          /* Apache Combined log type             */
#define LOG_DOMINO  5                           /* Lotus Domino, quoted user name else == #3 */

/* Response code defines as per draft ietf HTTP/1.1 rev 6 */
#define RC_CONTINUE           100
#define RC_SWITCHPROTO        101
#define RC_OK                 200
#define RC_CREATED            201
#define RC_ACCEPTED           202
#define RC_NONAUTHINFO        203
#define RC_NOCONTENT          204
#define RC_RESETCONTENT       205
#define RC_PARTIALCONTENT     206
#define RC_MULTIPLECHOICES    300
#define RC_MOVEDPERM          301
#define RC_MOVEDTEMP          302
#define RC_SEEOTHER           303
#define RC_NOMOD              304
#define RC_USEPROXY           305
#define RC_MOVEDTEMPORARILY   307
#define RC_BAD                400
#define RC_UNAUTH             401
#define RC_PAYMENTREQ         402
#define RC_FORBIDDEN          403
#define RC_NOTFOUND           404
#define RC_METHODNOTALLOWED   405
#define RC_NOTACCEPTABLE      406
#define RC_PROXYAUTHREQ       407
#define RC_TIMEOUT            408
#define RC_CONFLICT           409
#define RC_GONE               410
#define RC_LENGTHREQ          411
#define RC_PREFAILED          412
#define RC_REQENTTOOLARGE     413
#define RC_REQURITOOLARGE     414
#define RC_UNSUPMEDIATYPE     415
#define RC_RNGNOTSATISFIABLE  416
#define RC_EXPECTATIONFAILED  417
#define RC_SERVERERR          500
#define RC_NOTIMPLEMENTED     501
#define RC_BADGATEWAY         502
#define RC_UNAVAIL            503
#define RC_GATEWAYTIMEOUT     504
#define RC_BADHTTPVER         505

/* Index defines for RC codes */
#define IDX_UNDEFINED          0
#define IDX_CONTINUE           1
#define IDX_SWITCHPROTO        2
#define IDX_OK                 3
#define IDX_CREATED            4
#define IDX_ACCEPTED           5
#define IDX_NONAUTHINFO        6
#define IDX_NOCONTENT          7
#define IDX_RESETCONTENT       8
#define IDX_PARTIALCONTENT     9
#define IDX_MULTIPLECHOICES    10
#define IDX_MOVEDPERM          11
#define IDX_MOVEDTEMP          12
#define IDX_SEEOTHER           13
#define IDX_NOMOD              14
#define IDX_USEPROXY           15
#define IDX_MOVEDTEMPORARILY   16
#define IDX_BAD                17
#define IDX_UNAUTH             18
#define IDX_PAYMENTREQ         19
#define IDX_FORBIDDEN          20
#define IDX_NOTFOUND           21
#define IDX_METHODNOTALLOWED   22
#define IDX_NOTACCEPTABLE      23
#define IDX_PROXYAUTHREQ       24
#define IDX_TIMEOUT            25
#define IDX_CONFLICT           26
#define IDX_GONE               27
#define IDX_LENGTHREQ          28
#define IDX_PREFAILED          29
#define IDX_REQENTTOOLARGE     30
#define IDX_REQURITOOLARGE     31
#define IDX_UNSUPMEDIATYPE     32
#define IDX_RNGNOTSATISFIABLE  33
#define IDX_EXPECTATIONFAILED  34
#define IDX_SERVERERR          35
#define IDX_NOTIMPLEMENTED     36
#define IDX_BADGATEWAY         37
#define IDX_UNAVAIL            38
#define IDX_GATEWAYTIMEOUT     39
#define IDX_BADHTTPVER         40
#define TOTAL_RC               41

#define VERBOSE0 0
#define VERBOSE1 1
#define VERBOSE2 2
#define VERBOSE3 3
#define VERBOSE4 4
#define VERBOSE5 5
#define VERBOSE_MAX VERBOSE5

#define USESPACE true
#define IGNORESPACE false

/************************************************************************
 *                              MACROS                                  *
 ************************************************************************/
/* Where verbosity is a global, set once ONLY, defining what level of verboseness we are at */
#define VPRINT(level, ...) if (g_verbosity >= (level)) { printf(__VA_ARGS__); }
#define ERRVPRINT(level, ...) fflush (stdout); if (g_verbosity >= (level)) { fprintf(stderr, __VA_ARGS__); }

#define PCENT(val,max) ((val)?((double)val/(double)max)*100.0 : 0.0)
#define IDX_2C(c1,c2)       (((c1-'a'+1)<<5)+(c2-'a'+1) )
#define IDX_3C(c1,c2,c3)    (((c1-'a'+1)<<10)+((c2-'a'+1)<<5)+(c3-'a'+1) )
#define IDX_4C(c1,c2,c3,c4) (((c1-'a'+1)<<15)+((c2-'a'+1)<<10)+((c3-'a'+1)<<5)+(c4-'a'+1) )

#define INIT_CTRY(index, dom, descr)     j = (index) ; ctry[j].idx = ctry_idx(dom); ctry[j].domain = dom; ctry[j].desc = descr;
#define INIT_RESPCODE(index, descr)     response[(index)].desc = descr;

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif          /* not MAX */


/************************************************************************
 *                              GLOBALS                                 *
 ************************************************************************/
extern int g_verbosity;                         /* How many extra stuff to show. If 0, none
                                                   Bigger numbers, show more. */

/* Response code structure */
struct response_code {
    const char *desc;                           /* response code struct  */
    u_long count;
};

/* Country code structure */
struct country_code {
    u_long idx;
    const char *desc;
    const char *domain;
    unsigned long long pages;
    u_long count;
    u_long files;
    unsigned long long xfer;
};

typedef struct country_code *CLISTPTR;

/* log record structure */
struct log_struct {
    char hostname[MAXHOST];                     /* hostname             */
    char datetime[29];                          /* raw timestamp        */
    char url[MAXURL];                           /* raw request field    */
    int resp_code;                              /* response code        */
    u_long xfer_size;                           /* xfer size in bytes   */
    char refer[MAXREF];                         /* referrer             */
    char agent[MAXAGENT];                       /* user agent (browser) */
    char srchstr[MAXSRCH];                      /* search string        */
    char ident[MAXIDENT];
};                                              /* ident string (user)  */

extern struct log_struct log_rec;

const extern char *version;                     /* program version          */
const extern char *editlvl;                     /* edit level               */
const extern char *moddate;                     /* modification date        */
const extern char *copyright;

extern int verbose;                             /* 2=verbose,1=err, 0=none  */
extern int time_me;                             /* timing display flag      */
extern int local_time;                          /* 1=localtime 0=GMT (UTC)  */
extern int ignore_hist;                         /* history flag (1=skip)    */
extern int hourly_graph;                        /* hourly graph display     */
extern int hourly_stats;                        /* hourly stats table       */
extern int daily_graph;                         /* daily graph display      */
extern int daily_stats;                         /* daily stats table        */
extern int ctry_graph;                          /* country graph display    */
extern int url_byhits_graph;                    /* TOP URL's by Hits graph display    */
extern int url_byvol_graph;                     /* TOP URL's by Volume graph display    */
extern int exit_pages_graph;                    /* TOP Exit Pages Graph Display - 0 no, 1 hits, 2 visits */
extern int entry_pages_graph;                   /* TOP Entry Pages Graph Display - 0 no, 1 hits, 2 visits */
extern int sites_bypages_graph;                 /* TOP Sites Pages Graph - 0 no, 1 yes */
extern int sites_byvol_graph;                   /* TOP Sites Volume Graph - 0 no, 1 yes */
extern int agents_graph;                        /* TOP User Agents Graph - 0 no, 1 yes */
extern int shade_groups;                        /* Group shading 0=no 1=yes */
extern int hlite_groups;                        /* Group hlite 0=no 1=yes   */
extern int mangle_agent;                        /* mangle user agents       */
extern int incremental;                         /* incremental mode 1=yes   */
extern int use_https;                           /* use 'https://' on URL's  */
extern int visit_timeout;                       /* visit timeout (30 min)   */
extern int graph_legend;                        /* graph legend (1=yes)     */
extern int graph_lines;                         /* graph lines (0=none)     */
extern int fold_seq_err;                        /* fold seq err (0=no)      */
extern int log_type;                            /* (0=clf, 1=ftp, 2=squid)  */
extern bool force_log_type;                     /* Set to true if log_type set by Command line or Config File */
extern int group_domains;                       /* Group domains 0=none     */
extern int hide_sites;                          /* Hide ind. sites (0=no)   */
extern const char *hname;                       /* hostname for reports     */
extern const char *state_fname;                 /* run state file name      */
extern const char *hist_fname;                  /* name of history file     */
extern const char *html_ext;                    /* HTML file prefix         */
extern const char *dump_ext;                    /* Dump file prefix         */
extern const char *css_filename;                /* CSS file name            */
extern char *conf_fname;                        /* name of config file      */
extern char *log_fname;                         /* log file pointer         */
extern char *out_dir;                           /* output directory         */
extern char *blank_str;                         /* blank string             */
extern bool track_206_reqs;                     /* Track 206 Requests       */
extern bool display_match_counts;               /* Display the match counts vs Groups, Ignore's etc */
extern bool display_yearly_subtotals;           /* Display Yearly Subtotals on main page */
extern int index_months;                        /* Number of Months to display (12) */
extern int graph_index_x;                       /* Size of Main Graph X         */
extern int graph_index_y;                       /* Size of Main Graph Y         */
extern int graph_daily_x;                       /* Size of Monthly Graph X      */
extern int graph_daily_y;                       /* Size of Monthly Graph Y      */
extern int graph_hourly_x;                      /* Size of Daily Graph X        */
extern int graph_hourly_y;                      /* Size of Daily Graph Y        */
extern int graph_pie_x;                         /* Size of Pie Graph X  */
extern int graph_pie_y;                         /* Size of Pie Graph Y  */

extern int ntop_sites;                          /* top n sites to display   */
extern int ntop_sitesK;                         /* top n sites (by kbytes)  */
extern int ntop_urls;                           /* top n url's to display   */
extern int ntop_urlsK;                          /* top n url's (by kbytes)  */
extern int ntop_entry;                          /* top n entry url's        */
extern int ntop_exit;                           /* top n exit url's         */
extern int ntop_refs;                           /* top n referrers ""       */
extern int ntop_agents;                         /* top n user agents ""     */
extern int ntop_ctrys;                          /* top n countries   ""     */
extern int ntop_search;                         /* top n search strings     */
extern int ntop_users;                          /* top n users to display   */
extern int ntop_error;                          /* top n 404  to display   */

extern int all_sites;                           /* List All sites (0=no)    */
extern int all_urls;                            /* List All URL's (0=no)    */
extern int all_refs;                            /* List All Referrers       */
extern int all_agents;                          /* List All User Agents     */
extern int all_search;                          /* List All Search Strings  */
extern int all_users;                           /* List All Usernames       */
extern int all_errors;                          /* List All ErrorPages      */

extern int dump_sites;                          /* Dump tab delimited sites */
extern int dump_urls;                           /* URL's                    */
extern int dump_refs;                           /* Referrers                */
extern int dump_agents;                         /* User Agents              */
extern int dump_users;                          /* Usernames                */
extern int dump_search;                         /* Search strings           */
extern bool dump_countries;                     /* Countries                */
extern bool dump_entry_pages;                   /* Entry Pages              */
extern bool dump_exit_pages;                    /* Exit Pages               */
extern int dump_header;                         /* Dump header as first rec */
extern char *dump_path;                         /* Path for dump files      */

extern const char *flags_location;              /* Display Country Flags if not null */
extern bool use_geoip;                          /* If able, use GeoIP capability     */
extern bool have_geoip;                         /* If GeoIP is compiled in  */
extern const char *geoip_database;              /* location of the GeoIP Database file */

#if HAVE_GEOIP_H
extern GeoIP *gi;                               /* GeoIP access             */
#endif

extern u_long cur_tstamp;                       /* Current timestamp        */
extern u_long epoch;                            /* used for timestamp adj.  */
extern int check_dup;                           /* check for dups flag      */

extern int g_cur_year, g_cur_month,             /* year/month/day/hour      */
 g_cur_day, g_cur_hour,                         /* tracking variables       */
 g_cur_min, g_cur_sec;

extern unsigned long long t_xfer;               /* monthly total xfer value */
extern u_long t_hit, t_file, t_site,            /* monthly total vars       */
 t_url, t_ref, t_agent, t_page, t_visit, t_user;

extern u_long t_bad;                            /* total bad records */
extern u_long t_errorp;                         /* total error pages */
extern u_long t_ignored;                        /* total ignored records */


extern u_long t_bookmarks;

extern unsigned long long tm_xfer[31];          /* daily transfer totals    */

extern u_long tm_hit[31], tm_file[31],          /* daily total arrays       */
 tm_site[31], tm_page[31], tm_visit[31], tm_bookm[31];

extern u_long dt_site;                          /* daily 'sites' total      */

extern u_long ht_hit, mh_hit;                   /* hourly hits totals       */

extern u_long th_hit[24], th_file[24],          /* hourly total arrays      */
 th_page[24], th_bookm[24];

extern unsigned long long th_xfer[24];

extern int f_day, l_day;                        /* first/last day vars      */
extern int gz_log;                              /* flag for zipped log      */

extern CLISTPTR *top_ctrys;                     /* Top countries table      */

extern char hit_color[];                        /* graph hit color          */
extern char file_color[];                       /* graph file color         */
extern char site_color[];                       /* graph site color         */
extern char kbyte_color[];                      /* graph kbyte color        */
extern char page_color[];                       /* graph page color         */
extern char visit_color[];                      /* graph visit color        */
extern char bookm_color[];                      /* graph bookm color        */
extern char pie_color1[];                       /* pie additionnal color 1  */
extern char pie_color2[];                       /* pie additionnal color 2  */
extern char pie_color3[];                       /* pie additionnal color 3  */
extern char pie_color4[];                       /* pie additionnal color 4  */

/* define our externally visable functions */

extern char *current_time(void);
extern u_long ctry_idx(char *);
extern void init_counters(void);
extern void process_options(int, char *[]);
extern void get_config(const char *);           /* Read a config file  */
extern void generate_css_file(void);            /* Generate the CSS file */

extern u_long jdate(int, int, int);
extern void assign_messages(void);

#include "graphs.h"
#include "hashtab.h"
#include "messages.h"
#include "linklist.h"
#include "output.h"
#include "parser.h"
#include "preserve.h"


#endif          /* AWFFULL_AWFFULL_H */
