<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-story-admin.php                                    */
/* Author:      Paul Waite                                              */
/* Date:        June 2004                                               */
/* Description: Page where news stories are added/administered.         */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Articles", "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("story-defs.php");
include_once("form-defs.php");
include_once("button-defs.php");

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor,Author")) {
  $RESPONSE->send();
  exit;
}

// SORT ORDER
if (!isset($story_sortby)) {
  $story_sortby = "story_date DESC";
}

// STORY CATEGORY
$story_category = false;
if (isset($cat)) {
  $catQ = dbrecordset("SELECT * FROM ax_story_category WHERE category_id=$cat");
  if ($catQ->hasdata) {
    $HEADING = strtoupper($catQ->field("category_desc"));
    $story_category = $cat;
  }
}
if ($story_category === false) {
  $catQ = dbrecordset("SELECT * FROM ax_story_category");
  if ($catQ->hasdata) {
    $HEADING = strtoupper($catQ->field("category_desc"));
    $story_category = $catQ->field("category_id");
  }
}

// STORY LANGUAGE
if (isset($lang)) {
  $story_language = $lang;
}
else {
  $story_language = "0";
}

// TOOLBAR
// Add button
$addbtn = new form_imagebutton("add", "", "", "$LIBDIR/img/_add.gif", "Add a new article", 57, 15);
$href = "/axyl-story-viewer.php";
$href = href_addparm($href, "story_id",  -1);
$href = href_addparm($href, "cat",       $story_category);
$href = href_addparm($href, "lang",      $story_language);
$href = href_addparm($href, "auth_code", $RESPONSE->get_auth_code());
$addbtn->set_onclick("viewStory('$href')");

// Refresh button
$refbtn = new form_imagebutton("refresh", "", "", "$LIBDIR/img/_refresh.gif", "Refresh view", 77, 15);
$refbtn = new anchor("/axyl-story-admin.php", $refbtn->render());

if ($RESPONSE->has_multilang) {
  $langsel = new form_combofield("lang");
  $langsel->setclass("axcombo");
  $langs = dbrecordset("SELECT * FROM ax_language WHERE enabled=TRUE ORDER BY display_order");
  $langsel->additem("", "All");
  if ($langs->hasdata) {
    do {
      $langid = $langs->field("lang_id");
      $langdesc = $langs->field("lang_desc");
      $langsel->additem($langid, $langdesc);
    } while ($langs->get_next());
  }
  $langsel->setvalue($story_language);
  $langsel->setstyle("border-width:1px;border-style:solid;border-color:#22429a;background-color:#22429a;color:#ffffff;");
  $langsel->set_onchange("document.forms.storylist_fm.submit()");
}
else {
  $langsel = new form_hiddenfield("lang", "0");
}

$ordsel = new form_combofield("story_sortby");
$ordsel->setclass("axcombo");
$ordsel->additem("story_date DESC", "Date");
$ordsel->additem("story_author", "Author");
$ordsel->additem("story_headline", "Headline");
$ordsel->additem("last_modified DESC", "Last modified");
$ordsel->setvalue($story_sortby);
$ordsel->setstyle("border-width:1px;border-style:solid;border-color:#22429a;background-color:#22429a;color:#ffffff;");
$ordsel->set_onchange("document.forms.storylist_fm.submit()");

$Ttool = new table("toolbar");
$Ttool->tr();
$Ttool->setpadding(2);
$Ttool->setwidth("");
if ($RESPONSE->has_multilang) {
  $Ttool->td("Language");
}
$Ttool->td( $refbtn->render() );
$Ttool->td( $langsel->render() );
$Ttool->td( "Sorted by" );
$Ttool->td( $ordsel->render() );
$Ttool->td( $addbtn->render() );
$TOOLBAR = $Ttool->render();

// STORY LIST
$Tres = new table("stories");
$Tres->setpadding(5);
if ($RESPONSE->microsite_detected != "") {
  $q  = "SELECT *";
  $q .= "  FROM ax_language l, ax_microsite_story ms, ax_story s LEFT OUTER JOIN ax_user u ON u.user_id=s.story_author";
  $q .= " WHERE l.lang_id=s.lang_id";
  $q .= "   AND ms.microsite_name='" . addslashes($RESPONSE->microsite_detected) . "'";
  $q .= "   AND s.story_id=ms.story_id";
  $q .= "   AND s.deleted=FALSE";
}
else {
  $q = "SELECT * FROM ax_language l, ax_story s LEFT OUTER JOIN ax_user u ON u.user_id=s.story_author";
  $q .= " WHERE l.lang_id=s.lang_id";
  $q .= "   AND s.deleted=FALSE";
  // Filter out any microsite stories..
  if ($RESPONSE->microsites_mode == MICROSITES_ENABLED) {
    $q .= " AND NOT EXISTS (";
    $q .= "  SELECT * FROM ax_microsite_story ms";
    $q .= "   WHERE ms.story_id=s.story_id";
    $q .= " )";
  }
}

$filterby_category = isset($story_category) && $story_category != "" && is_numeric($story_category);
$filterby_language = isset($story_language) && $story_language != "" && is_numeric($story_language);
if ($filterby_category) {
  $q .= " AND s.category_id=$story_category";
}
if ($filterby_language) {
  $q .= " AND s.lang_id=$story_language";
}
if (isset($story_sortby)) {
  $q .= " ORDER BY $story_sortby";
}
$storyQ = dbrecordset($q);
if ($storyQ->hasdata) {
  $septoggle = true;
  do {
    $showcount += 1;
    $story_id        = $storyQ->field("story_id");
    $story_date      = datetime_to_displaydate(NICE_DATE, $storyQ->field("story_date"));
    $story_time      = datetime_to_displaydate(NICE_TIME_ONLY, $storyQ->field("story_date"));
    $story_precis    = strip_tags($storyQ->field("story_precis"));
    if ($story_precis == "") {
      $story = new story($story_id);
      $story_precis = $story->make_precis();
    }
    $story_author    = $storyQ->field("story_author");
    $story_language  = $storyQ->field("lang_desc");
    $author_name     = $storyQ->field("full_name");
    $story_headline   = strip_tags($storyQ->field("story_headline"));
    if ($story_headline == "") $story_headline = "(No Headline)";

    // Background separator style..
    if ($septoggle) $sepclass = "tabgdark";
    else $sepclass = "tabglite";
    $septoggle = !$septoggle;

    // Story href query string..
    $hrefqry = "story_id=$story_id&auth_code=" . $RESPONSE->get_auth_code();
    $href = "javascript:viewStory('/axyl-story-viewer.php?$hrefqry')";
    $storylink = new Link($href, strtoupper($story_headline));
    $storylink->set_linkover_text("View story #$story_id");

    $Tres->tr($sepclass);

    $Tres->td("$story_date<br>$story_time");
    $Tres->td_alignment("", "top");

    $s = $storylink->render();
    if ($author_name != "") {
      $s .= "<br>by $author_name";
    }
    if (!$filterby_language) {
      if ($story_language == "default") {
        $s .= " (default language)";
      }
      else {
        $s .= " (in $story_language)";
      }
    }
    if ($story_precis != "") {
      $s .= "<br>$story_precis...";
    }
    $Tres->td($s);
    $Tres->td_alignment("", "top");
  } while ($storyQ->get_next());
}
// Store results for later on..
$ARTICLES_LIST = $Tres->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name="storylist_fm" method="post">
<table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
  <tr class="axtitle">
    <td align="center" class="axtitle"><!--HEADING--></td>
  </tr>
  <tr class="axyl_rowstripe_lite">
    <td align="right"><!--TOOLBAR--></td>
  </tr>
  <tr class="axyl_rowstripe_dark">
    <td valign=top><!--ARTICLES_LIST--></td>
  </tr>
  <tr class="axfoot">
    <td></td>
  </tr>
</table>
</form>
<?php
$RESPONSE->plugin_inline();

// Popups for story editing/creation..
$RESPONSE->head->add_script(
    "var storyWin=null;\n"
  . "function viewStory(theurl) {\n"
  . "  var winFeatures='status=yes,resizable=yes,scrollbars=yes,width=700,height=650,left=120,top=20';\n"
  . "  windowopen(theurl, 'StoryViewer', winFeatures);\n"
  . "  storyWin = newwin;\n"
  . "  if (storyWin != null) storyWin.focus();\n"
  . "}\n"
  );

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("TOOLBAR",           $TOOLBAR);
$RESPONSE->plugin("ARTICLES_LIST",     $ARTICLES_LIST);
if ($RESPONSE->microsite_detected != "") {
  $RESPONSE->plugin("MAIN_MENU", "main_menu()");
}

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>