/*
	$Id: treeview_item.h,v 1.2 2001/12/28 00:11:46 sphair Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Controls"
//! header=gui.h

#ifndef header_treeview_item
#define header_treeview_item

#include "component.h"

class CL_TreeView_Item_Generic;

//: TreeView_Item component
class CL_TreeView_Item : public CL_Component
{
//! Construction:
public:
	//: TreeView Item Constructor
	CL_TreeView_Item(
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: TreeView Item Constructor
	CL_TreeView_Item(
		const std::string &text,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: TreeView Item Destructor
	virtual ~CL_TreeView_Item();

//! Attributes:
public:
	//: Is open or closed
	bool is_open() const;

	//: Is highlighted
	bool is_highlighted() const;

	//: Has submenu
	bool has_subtree() const;

	//: Returns the item label.
	//- Returns - The item label.
	const std::string &get_text() const;

//! Operations:
public:
	//: Sets the item label.
	//- text - The item label.
	void set_text(const std::string &text);

//! Signals:
public:
	//: This signal is emitted when the item is clicked on.
	CL_Signal_v0 &sig_clicked();

//! Implementation:
private:
	CL_TreeView_Item(const CL_TreeView_Item &copy) : CL_Component(NULL, NULL) { return; } // disallow copy construction.
	CL_TreeView_Item_Generic *impl;
};

#endif
