/*
	$Id: menuitem_default.h,v 1.20 2001/09/24 20:21:35 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_menuitem_default
#define header_menuitem_default

#include "API/GUI/menuitem.h"
#include "API/GUI/component_style.h"

class CL_Font;
class CL_Surface;
class CL_StyleManager_Default;

class CL_MenuItem_Default : public CL_ComponentStyle
{
public:
	CL_MenuItem_Default(
		CL_MenuItem *menuitem,
		const CL_ComponentOptions &options,
		CL_StyleManager_Default *style);

	virtual ~CL_MenuItem_Default();

	int calc_height();
	int calc_width();

	int calc_text_width();
	int calc_surface_check_width();
	int calc_surface_icon_width();
	int calc_surface_submenu_width();

	void set_surface_check_pos(int pos) { surface_check_pos = pos; }
	void set_surface_icon_pos(int pos) { surface_icon_pos = pos; }
	void set_surface_submenu_pos(int pos) { surface_submenu_pos = pos; }
	void set_text_pos(int pos) { text_pos = pos; }
	
	void set_draw_style(bool filled);
	
	void on_paint();
	void on_get_preferred_size(CL_Point &size);

private:
	CL_Slot slot_paint;
	CL_Slot slot_get_preferred_size;

	CL_MenuItem *menuitem;

	bool draw_filled;
	bool draw_submenu_icon;

	int surface_check_pos;
	int surface_icon_pos;
	int surface_submenu_pos;
	int text_pos;

	CL_Font *font;

	CL_Surface *sur_icon;
	CL_Surface *sur_checked;
	CL_Surface *sur_unchecked;
	CL_Surface *sur_submenu;

	CL_StyleManager_Default *style;
	CL_ResourceManager *resources;
};

#endif
