/*
	$Id: selection_list.cpp,v 1.29 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/Core/Input/input.h"
#include "API/Core/Font/font.h"
#include "API/GUI/gui_manager.h"
#include "API/GUI/scrollbar.h"
#include "selection_list.h"

#define SELECTIONLIST_DEFAULT_MAX_HEIGHT 5

CL_SelectionList::CL_SelectionList(
	const CL_ComponentOptions &options,
	CL_Component *parent,
	CL_StyleManager_Default *style,
	CL_Font *_font,
	const std::list<std::string> &_selection_list) : CL_Component(style,parent)
{
	this->style = style;
	selection_list = _selection_list;
	font = _font;
	highlighted_option = -1;

	int x, y, width, height;
	x = options.get_value_as_int("x");
	y = options.get_value_as_int("y");
	width = options.get_value_as_int("width");

	max_height = SELECTIONLIST_DEFAULT_MAX_HEIGHT;
	if (options.exists("height"))
		max_height = options.get_value_as_int("height");
	if (max_height > selection_list.size())
		max_height = selection_list.size();
	if (options.exists("value"))
		highlighted_option = options.get_value_as_int("value");

	height = font->get_height()*max_height;
	
	set_position(CL_Rect(x, y, x + width, y + height));

	slots.add_slot(sig_key_down().connect(this, &CL_SelectionList::on_key_down));
	slots.add_slot(sig_mouse_moved().connect(this, &CL_SelectionList::on_mouse_move));
	slots.add_slot(sig_paint().connect(this, &CL_SelectionList::on_paint));
	slots.add_slot(sig_lost_focus().connect(this, &CL_SelectionList::cancel));

	scrollbar = NULL;
	has_scrollbar = false;
	scroll_offset = 0;
	if (selection_list.size() > max_height)
	{
		has_scrollbar = true;
		CL_ComponentOptions s_options;

#ifdef BORLAND
		s_options.options.insert(std::make_pair(std::string("orientation"), std::string("ver")));
		s_options.options.insert(std::make_pair(std::string("x"), std::string(CL_String(get_width()-17))));
		s_options.options.insert(std::make_pair(std::string("y"), std::string("1")));
		s_options.options.insert(std::make_pair(std::string("height"), std::string(CL_String(get_height()-2))));
		s_options.options.insert(std::make_pair(std::string("range"), std::string(CL_String(int(selection_list.size()-max_height)))));
		s_options.options.insert(std::make_pair(std::string("scroller_size"), std::string("16")));
		if (highlighted_option != -1)
		{
			s_options.options.insert(std::make_pair(std::string("value"), std::string(CL_String(highlighted_option))));
		}
#else
		s_options.options.insert(std::make_pair<std::string const, std::string>("orientation", "ver"));
		s_options.options.insert(std::make_pair<std::string const, std::string>("x", CL_String(get_width()-17)));
		s_options.options.insert(std::make_pair<std::string const, std::string>("y", "1"));
		s_options.options.insert(std::make_pair<std::string const, std::string>("height", CL_String(get_height()-2)));
		s_options.options.insert(std::make_pair<std::string const, std::string>("range", CL_String(int(selection_list.size()-max_height))));
		s_options.options.insert(std::make_pair<std::string const, std::string>("scroller_size", "16"));
		if (highlighted_option != -1)
		{
			s_options.options.insert(std::make_pair<std::string const, std::string>("value", CL_String(highlighted_option)));
		}
#endif

		scrollbar = CL_ScrollBar::create(s_options, this, style);
		slots.add_slot(scrollbar->sig_scrolled.connect(this, &CL_SelectionList::on_scroll_change));
		add_child(scrollbar, true);

		scroll_offset = scrollbar->get_cur_position();
	}
}

void CL_SelectionList::on_paint()
{
//	int height = font->get_height() * min(selection_list.size(), max_height);

	style->draw_line(0, 0, get_width()-1, 0, GUICOL_DARK_OUTLINE);
	style->draw_line(0, get_height()-1, get_width()-1, get_height()-1, GUICOL_DARK_OUTLINE);
	style->draw_line(0, 0, 0, get_height()-1, GUICOL_DARK_OUTLINE);
	style->draw_line(get_width()-1, 0, get_width()-1, get_height()-1, GUICOL_DARK_OUTLINE);
	style->fill_rect(1, 1, get_width()-1, get_height()-1, GUICOL_TEXT_BG);

	int pos = 0;
	std::list<std::string>::iterator it = selection_list.begin();
	for (;it!=selection_list.end();it++)
	{
		if (pos < scroll_offset)
		{
			pos++;
			continue;
		}
		if (pos == highlighted_option)
		{
			style->fill_rect(
				1,
				1+(pos-scroll_offset)*font->get_height(),
				get_width()-1,
				1+(pos+1-scroll_offset)*font->get_height(),
				GUICOL_SELECTION);
		}
		font->print_left(4, 1+(pos-scroll_offset)*font->get_height(), (*it).c_str());
		pos++;
	}
}

void CL_SelectionList::cancel()
{
	sig_cancelled();
	close();
//	get_gui_manager()->remove_component(this);
}

void CL_SelectionList::on_key_down(CL_Component *comp, CL_InputDevice *device, CL_Key key)
{
	if (device != CL_Input::pointers[0] || key.id != 0) return;
	if (has_scrollbar && key.x >= get_width()-scrollbar->get_width()) return;

	if(has_focus())
	{
		sig_activated(highlighted_option);
		close();
//		get_gui_manager()->remove_component(this);
	}
	else
	{
//		get_gui_manager()->remove_component(this);
		cancel();
	}
}

void CL_SelectionList::on_mouse_move(CL_Component *comp, CL_InputDevice *device, int x, int y)
{
	if (has_scrollbar && x >= get_width()-scrollbar->get_width())
		return;

	highlighted_option = y / font->get_height()+scroll_offset;
}

void CL_SelectionList::on_scroll_change(int new_offset)
{
	scroll_offset = new_offset;
}
