# test the calculator in sick mode

use IPC::Open3 qw(open3);

my @tests = (
    ['DO .1 <- #V2', 'OK'],
    ['DO .2 <- .V1', 'OK'],
    ['.1', 'III'],
    ['.2', 'xxxiiDCCLXXI'],
    ['PLEASE IGNORE .2', 'OK'],
    ['DO .2 <- #666', 'OK'],
    ['.2', 'xxxiiDCCLXXI'],
    ['PLEASE REMEMBER .2', 'OK'],
    ['DO .2 <- #666', 'OK'],
    ['.2', 'DCLXVI'],
    ['#-2', 'II'],
    ['.-2', 'II'],
    # XXX more tests are necessary
);

my $maxtest = @tests;
print "1..$maxtest\n";

my @l = map { "-I$_" } @INC;
my $pid = open3(\*READ, \*WRITE, \*WRITE, $^X, @l, 'bin/intercalc', '--batch', '-mfull', '-lsick');

select READ; $| = 1; select STDOUT;

my $testnum = 1;
for my $test (@tests) {
    my ($cmd, $res) = @$test;
    print READ "$cmd\n";
    my $line = <WRITE>;
    chomp $line;
    while ($line =~ /loading compiler/i) {
	$line = <WRITE>;
	chomp $line;
    }
    $line =~ s/^\s+//;
    my ($gr, $gc) = split(/\s+/, $line, 2);
    my $not = 'not ';
    if ($gr ne $res) {
	print STDERR "FAIL $testnum res ($gr ne $res)\n";
    } else {
	$not = '';
    }
    print "${not}ok ", $testnum++, "\n";
}

