/* keyresponses.c
 * switching station for processing user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include <gdk/gdkkeysyms.h>
#include "commandfuncs.h"
#include "datastructures.h"
#include "draw.h"
#include "kbd-custom.h"
#include "selectops.h"

void
scorearea_keypress_event (GtkWidget * widget, GdkEventKey * event,
			  gpointer data)
{
  struct scoreinfo *si = data;
  struct keybinding_info *ki;

  /* Look up the keystroke in the keymap and execute the appropriate
   * function */

  if (ki = lookup_keybinding (si->prefs->the_keymap, event->keyval,
			      event->state))
    {
      if (ki->callback_action == -1)
	ki->func.nocallback (si);
      else
	ki->func.callback (si, ki->callback_action, NULL);
      gtk_widget_draw (si->scorearea, NULL);
    }
}

void
adjust_measure_less_width_key (struct scoreinfo *si)
{
  adjustmeasurewidth (si, -10);
}

void
adjust_measure_more_width_key (struct scoreinfo *si)
{
  adjustmeasurewidth (si, 10);
}

void
adjust_staff_less_height_key (struct scoreinfo *si)
{
  adjuststaffheight (si, -10);
}

void
adjust_staff_more_height_key (struct scoreinfo *si)
{
  adjuststaffheight (si, 10);

}

void
unset_selection_key (struct scoreinfo *si)
{
  si->markstaffnum = 0;
}

void
insert_chord_key (struct scoreinfo *si)
{
  insertchord (si, 2, FALSE);
}

void
go_to_A_key (struct scoreinfo *si)
{
  shiftcursor (si, 5);
}

void
go_to_B_key (struct scoreinfo *si)
{
  shiftcursor (si, 6);
}

void
go_to_C_key (struct scoreinfo *si)
{
  shiftcursor (si, 0);
}

void
go_to_D_key (struct scoreinfo *si)
{
  shiftcursor (si, 1);
}

void
go_to_E_key (struct scoreinfo *si)
{
  shiftcursor (si, 2);
}

void
go_to_F_key (struct scoreinfo *si)
{
  shiftcursor (si, 3);
}

void
go_to_G_key (struct scoreinfo *si)
{
  shiftcursor (si, 4);
}

void
octave_up_key (struct scoreinfo *si)
{
  si->cursor_y += 7;
}

void
octave_down_key (struct scoreinfo *si)
{
  si->cursor_y -= 7;
}

void
rest_toggle_key (struct scoreinfo *si)
{
  si->rest_mode = !si->rest_mode;
}

void
append_measure_key (struct scoreinfo *si)
{
  appendmeasures (si, 1);
}

void
insert_measure_key (struct scoreinfo *si)
{
  insertmeasures (si, 1);
}

void
change_duration_0key (struct scoreinfo *si)
{
  changeduration (si, 0);
}

void
change_duration_1key (struct scoreinfo *si)
{
  changeduration (si, 1);
}

void
change_duration_2key (struct scoreinfo *si)
{
  changeduration (si, 2);
}

void
change_duration_3key (struct scoreinfo *si)
{
  changeduration (si, 3);
}

void
change_duration_4key (struct scoreinfo *si)
{
  changeduration (si, 4);
}

void
change_duration_5key (struct scoreinfo *si)
{
  changeduration (si, 5);
}

void
change_duration_6key (struct scoreinfo *si)
{
  changeduration (si, 6);
}

void
insert_chord_0key (struct scoreinfo *si)
{
  insertchord (si, 0, FALSE);
}

void
insert_chord_1key (struct scoreinfo *si)
{
  insertchord (si, 1, FALSE);
}

void
insert_chord_2key (struct scoreinfo *si)
{
  insertchord (si, 2, FALSE);
}

void
insert_chord_3key (struct scoreinfo *si)
{
  insertchord (si, 3, FALSE);
}

void
insert_chord_4key (struct scoreinfo *si)
{
  insertchord (si, 4, FALSE);
}

void
insert_chord_5key (struct scoreinfo *si)
{
  insertchord (si, 5, FALSE);
}

void
insert_chord_6key (struct scoreinfo *si)
{
  insertchord (si, 6, FALSE);
}

void
insert_rest_0key (struct scoreinfo *si)
{
  insertchord (si, 0, TRUE);
}

void
insert_rest_1key (struct scoreinfo *si)
{
  insertchord (si, 1, TRUE);
}

void
insert_rest_2key (struct scoreinfo *si)
{
  insertchord (si, 2, TRUE);
}

void
insert_rest_3key (struct scoreinfo *si)
{
  insertchord (si, 3, TRUE);
}

void
insert_rest_4key (struct scoreinfo *si)
{
  insertchord (si, 4, TRUE);
}

void
insert_rest_5key (struct scoreinfo *si)
{
  insertchord (si, 5, TRUE);
}

void
insert_rest_6key (struct scoreinfo *si)
{
  insertchord (si, 6, TRUE);
}

void
insert_tuplet_0key (struct scoreinfo *si)
{
  inserttuplet (si, 0);
}

void
insert_tuplet_1key (struct scoreinfo *si)
{
  inserttuplet (si, 1);
}

void
insert_tuplet_2key (struct scoreinfo *si)
{
  inserttuplet (si, 2);
}

void
insert_tuplet_3key (struct scoreinfo *si)
{
  inserttuplet (si, 3);
}

void
insert_tuplet_4key (struct scoreinfo *si)
{
  inserttuplet (si, 4);
}

void
insert_tuplet_5key (struct scoreinfo *si)
{
  inserttuplet (si, 5);
}

void
insert_tuplet_6key (struct scoreinfo *si)
{
  inserttuplet (si, 6);
}

void
insert_tuplet_7key (struct scoreinfo *si)
{
  inserttuplet (si, 7);
}

void
insert_tuplet_9key (struct scoreinfo *si)
{
  inserttuplet (si, 9);
}

void
add_tone_key (struct scoreinfo *si)
{
  tonechange (si, FALSE);
}

void
remove_tone_key (struct scoreinfo *si)
{
  tonechange (si, TRUE);
}

void
backspace_key (struct scoreinfo *si)
{
  /* remove the object preceding the cursor, within the current measure */
  if (si->cursor_x)
    {
      /* Then move the cursor back */
      cursorleft (si);
      /* And delete */
      deleteobject (si);
    }
}

void
sharpen_key (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  if (curmudelaobj && curmudelaobj->type == STEMDIRECTIVE)
    change_stem_directive (si, 1);
  else
    changeenshift (si, 1);
}

void
flatten_key (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  if (curmudelaobj && curmudelaobj->type == STEMDIRECTIVE)
    change_stem_directive (si, -1);
  else
    changeenshift (si, -1);
}

void
tie_notes_key (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.is_tied = !curmudelaobj->u.chordval.is_tied;
}

void
add_dot_key (struct scoreinfo *si)
{
  changedots (si, 1);
}

void
remove_dot_key (struct scoreinfo *si)
{
  changedots (si, -1);
}


void
add_accent (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.is_accented_p =
      !curmudelaobj->u.chordval.is_accented_p;
}

void
add_fermata (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.has_fermata_p =
      !curmudelaobj->u.chordval.has_fermata_p;
}

void
add_staccato (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.has_stacatto_p =
      !curmudelaobj->u.chordval.has_stacatto_p;
}

void
add_tenuto (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD)
    curmudelaobj->u.chordval.has_tenuto_p =
      !curmudelaobj->u.chordval.has_tenuto_p;
}


void
add_trill (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.has_trill_p =
      !curmudelaobj->u.chordval.has_trill_p;
}

void
add_turn (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.has_turn_p =
      !curmudelaobj->u.chordval.has_turn_p;
}

void
add_mordent (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.has_mordent_p =
      !curmudelaobj->u.chordval.has_mordent_p;

}

void
add_staccatissimo (struct scoreinfo *si)
{
  mudelaobject *curmudelaobj =
    si->currentobject ? si->currentobject->data : NULL;
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      curmudelaobj->u.chordval.tones)
    curmudelaobj->u.chordval.has_staccatissimo_p =
      !curmudelaobj->u.chordval.has_staccatissimo_p;

}

void
set_grace (struct scoreinfo *si)
{
  insertgrace (si);
}
