/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * GTK+ interface internals
 */
/*
 * routines to create GTK interface.
 * $Id: dmachinemon-gtkiface-gtk.c,v 1.4 2001/12/04 08:25:19 dancer Exp $
 */
/* 
 * GTK+ interface for load average monitor program.
 * 2001 Jun 9 Junichi Uekawa
 */
/* 
 * code to do some timeout temperature monitoring.
 * a sample code to monitor the load average of a machine.
 * 5 June 2001. Copyright 2001 Junichi Uekawa
 * call this proggie with a command-line like :
 *   ./tempmon /proc/sys/dev/sensors/via686a-isa-6000/temp?
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <locale.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include "dmachinemon-gtkiface.h"

static gint delete_event (GtkWidget * w, GdkEvent * e, gpointer data)
{				/* I will be deleted */
  return FALSE;  
}

static gint destroy_callback (GtkWidget * w, gpointer data)
{
  gtk_main_quit();
  return 0;  
}

void CreateApplicationDataTitle(GtkWidget* hbox, const char * s)
{
  GtkWidget * w = gtk_button_new_with_label(s);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_widget_show(w);
}

GtkWidget* CreateApplicationDataLoad(GtkWidget* hbox)
{
  GtkWidget * w = gtk_progress_bar_new();

  gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR (w), GTK_PROGRESS_CONTINUOUS);
  gtk_progress_set_format_string(GTK_PROGRESS(w), "%v%% [%l-%u]");
  gtk_progress_set_show_text(GTK_PROGRESS(w), TRUE);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_widget_show(w);  
  return w;
 
}

GtkWidget* CreateApplicationDataMem(GtkWidget* hbox)
{
  GtkWidget * w = gtk_progress_bar_new();

  gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR (w), GTK_PROGRESS_CONTINUOUS);
  gtk_progress_set_format_string(GTK_PROGRESS(w), "%vMB/%u");
  gtk_progress_set_show_text(GTK_PROGRESS(w), TRUE);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_widget_show(w);
  return w;
}

GtkWidget* CreateApplicationDataPingType(GtkWidget* hbox)
{				/* Create a text-data field. */
  GtkWidget * w = gtk_label_new("None");
  gtk_box_pack_start(GTK_BOX(hbox), w, 
		     TRUE,
		     TRUE,
		     FALSE);
  gtk_widget_show(w);
  return w;
}

GtkWidget* CreateApplicationDataNetload(GtkWidget* hbox)
{
  GtkWidget * w = gtk_progress_bar_new();

  gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR (w), GTK_PROGRESS_CONTINUOUS);
  gtk_progress_set_format_string(GTK_PROGRESS(w), "%vB");
  gtk_progress_set_show_text(GTK_PROGRESS(w), TRUE);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_widget_show(w);
  return w;
}


void *CreateApplicationData(GtkWidget* vbox, const char * stringdata)
{
  ApplicationData * m = malloc(sizeof(ApplicationData));  
  GtkWidget * horz = gtk_hbox_new(TRUE, FALSE);

  m->mainhbox = horz;
  gtk_box_pack_start (GTK_BOX(vbox), horz, TRUE, TRUE, FALSE);
  CreateApplicationDataTitle(horz, stringdata);
  m->loadavg = CreateApplicationDataLoad(horz);
  m->memory = CreateApplicationDataMem(horz);
  m->pingtime = CreateApplicationDataPingType(horz);  
  m->topapplication = CreateApplicationDataPingType(horz);  
  m->topuser = CreateApplicationDataPingType(horz);
  m->netload = CreateApplicationDataNetload(horz);
  gtk_widget_show(horz);
  return m;  
}



void CreateHeadingsOne(GtkWidget*hbox, const char * text)
{
  GtkWidget * a = gtk_button_new_with_label(text);
  gtk_box_pack_start (GTK_BOX(hbox), a, TRUE, TRUE, FALSE);
  gtk_widget_show(a);
}

void CreateHeadings(GtkWidget *vbox)
{
  GtkWidget * horz = gtk_hbox_new(TRUE, FALSE);
  gtk_box_pack_start (GTK_BOX(vbox), horz, FALSE, FALSE, FALSE);
  CreateHeadingsOne(horz, "Machine name");
  CreateHeadingsOne(horz, "Load average");
  CreateHeadingsOne(horz, "Memory");
  CreateHeadingsOne(horz, "Last ping");
  CreateHeadingsOne(horz, "Top Application");
  CreateHeadingsOne(horz, "Top user");
  CreateHeadingsOne(horz, "Network load");
  gtk_widget_show(horz);
}

GtkWidget * CreateVBox(GtkWidget * w)
{
  GtkWidget * v = gtk_vbox_new (FALSE, FALSE);  
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (w), v);
  CreateHeadings(v);  
  gtk_widget_show(v);  
				/* this v is the vbox people should add their objects to. */
  return v;  
}


GtkWidget* CreateScrollableWindow(GtkWidget* w)
{
  GtkWidget* vbox;
  GtkWidget * s = gtk_scrolled_window_new(NULL, NULL);
  vbox=CreateVBox(s);
  gtk_container_add(GTK_CONTAINER (w), s);  
  gtk_widget_show(s);  
  return vbox;  
}

GtkWidget* CreateMainWindow(void)
{
  GtkWidget *winMain ;  
  GtkWidget * vbox;
  
  winMain=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (winMain, 512, 400);
  
  gtk_signal_connect (GTK_OBJECT(winMain), "delete_event", 
		      GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT(winMain), "destroy",
		      GTK_SIGNAL_FUNC(destroy_callback), NULL);  
  vbox=CreateScrollableWindow(winMain);
  gtk_widget_show(winMain);
  return vbox;
  
}
