/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * GTK+ interface
 */
/* 
 * GTK+ interface for load average monitor program.
 * 2001 Jun 9 Junichi Uekawa
 * $Id: dmachinemon-gtkiface.c,v 1.8 2001/12/04 08:25:19 dancer Exp $
 * 2001-Aug-17 dancer  removed misleading comments from temp monitoring.
 * 2001 Nov 12 dancer  improved the interface and added topprocess/user.
 */
/* 
 * Code derived from :
 * code to do some timeout temperature monitoring.
 * a sample code to monitor the load average of a machine.
 * 5 June 2001. Copyright 2001 Junichi Uekawa
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>

#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon-gtkiface.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "VERSION.h"

				/* The gauge maxes out on 100% load */
const float MAXLOADVAL = 100.0;



char * hostname ;
int portnumber;


GtkWidget* CreateMainWindow();

pthread_mutex_t gtk_lock = PTHREAD_MUTEX_INITIALIZER;

pthread_mutex_t timeout_lock = PTHREAD_MUTEX_INITIALIZER;

void * Call_CreateApplicationData ( void * data, const char * stringdata)
{
  return CreateApplicationData(data, stringdata);
}

gint timeout_command (gpointer data)
{
  int fd = dm_connect_to_host(hostname, portnumber);
  FILE* f=(fd!=-1)?fdopen (fd, "r"):NULL;
  dm_machinelist * new = NULL;
  static float max_networkload = 0; /* the maximum network load. */

  pthread_mutex_lock(&timeout_lock);

  if (!f)
    {
      fprintf(stderr, "dmachinemon_gtkiface: Cannot open server socket\n");
      exit(1);      
    }

  if (dm_process_nodes_input (f, &maininfo, Call_CreateApplicationData, data))
    {
      fprintf (stderr, "Could not handle input...\n");
      return 1;
    }
  fclose(f);

				/* displaying process */
  
  pthread_mutex_lock (&gtk_lock);
  new = maininfo.machinedb;
  while(new)
    {
      time_t t;      
      struct tm tmm;
      char buf[26];
      char * topprocessname = NULL;
      char * topprocessname_short ;
      
      float value_load1 = dm_get_value_float(new, "load1") * 100.0;      
      float value_network1 = dm_get_value_float ( new, "network-eth0-recv") + dm_get_value_float ( new, "network-eth0-send") ;
      
      
      ApplicationData *a = ( ( ApplicationData *) (new -> applicationdata )) ;

      gtk_progress_configure(GTK_PROGRESS(a -> loadavg), value_load1, 0.0, value_load1 > MAXLOADVAL ? value_load1 : MAXLOADVAL);
      gtk_progress_configure(GTK_PROGRESS(a -> memory), dm_get_value_float(new, "memused")/1024.0/1024.0, 0.0, dm_get_value_float(new, "memtotal")/1024.0/1024.0);
      
      t = atol(dm_get_value_text(new, "time"));      
      localtime_r(&t, &tmm); 
      asctime_r(&tmm, buf);
      gtk_label_set_text (GTK_LABEL(a -> pingtime), buf);
      
      topprocessname = strdup(dm_get_value_text(new, "topprocess"));
      if (strlen (topprocessname) > 20)
	topprocessname_short = topprocessname + strlen(topprocessname) -20;
      else
	topprocessname_short = topprocessname;
      gtk_label_set_text (GTK_LABEL(a -> topapplication), topprocessname_short);
      free (topprocessname);
            
      gtk_label_set_text (GTK_LABEL(a -> topuser), dm_get_value_text(new, "topuser"));

      if (value_network1 > max_networkload) 
	{
	  max_networkload = value_network1;
	}
      gtk_progress_configure(GTK_PROGRESS(a -> netload), value_network1, 0.0, max_networkload);
      
      new = new -> next;
    }  
  
  pthread_mutex_unlock (&gtk_lock);

  pthread_mutex_unlock(&timeout_lock);
  
  return 1;  
}

int main(int ac, char ** av)
{  
  gint hTimeout;
  GtkWidget*vbox;
  dm_commandoption cdat;

  dmachinemon_parse_options(ac, av, &cdat);
  if (!cdat.parenthostname)
    {
      fprintf (stderr, 
	       "dmachinemon-gtkiface v. %s \n\n"
	       "Not enough command-line information specified\n\n"
	       ,DMACHINEMON_VERSION
	       );
      dmachinemon_print_commandline_help();
      return 1;
    }

  setlocale(LC_TIME, "");
  hostname=cdat.parenthostname;
  portnumber=atoi(cdat.port_client);

  gtk_init(&ac, &av);
  
  pthread_mutex_lock(&gtk_lock);
  vbox=CreateMainWindow();
  pthread_mutex_unlock(&gtk_lock);
  
  hTimeout = gtk_timeout_add(1000 * cdat.sleeptime, timeout_command, vbox);
  gtk_main();  
  gtk_timeout_remove(hTimeout);
  return 0;
}

