/*
$Id: cmdline.c,v 1.38 2004/11/03 21:00:59 rasc Exp $


 DVBSNOOP

 a dvb sniffer  and mpeg2 stream analyzer tool
 http://dvbsnoop.sourceforge.net/

 (c) 2001-2004   Rainer.Scherg@gmx.de (rasc)






$Log: cmdline.c,v $
Revision 1.38  2004/11/03 21:00:59  rasc
 - New: "premiere.de" private tables and descriptors (tnx to Peter.Pavlov, Premiere)
 - New: cmd option "-privateprovider <provider name>"
 - New: Private provider sections and descriptors decoding
 - Changed: complete restructuring of private descriptors and sections

Revision 1.37  2004/10/12 21:12:05  rasc
no message

Revision 1.36  2004/10/12 20:37:48  rasc
 - Changed: TS pid filtering from file, behavior changed
 - New: new cmdline option -maxdmx <n>  (replaces -f using pidscan)
 - misc. changes

Revision 1.35  2004/09/01 20:20:34  rasc
new cmdline option: -buffersize KB  (set demux buffersize in KBytes)

Revision 1.34  2004/04/15 03:38:50  rasc
new: TransportStream sub-decoding (ts2PES, ts2SEC)  [-tssubdecode]
checks for continuity errors, etc. and decode in TS enclosed sections/pes packets

Revision 1.33  2004/04/01 19:19:06  rasc
cmdline options renamed...

Revision 1.32  2004/03/31 21:14:23  rasc
New: Spider section pids  (snoop referenced section pids),
some minor changes

Revision 1.31  2004/03/21 00:37:47  rasc
Query FrontEnd Info  (option: -s feinfo)

Revision 1.30  2004/03/09 20:59:23  rasc
VPS decoding (someone check the NPP & PTY code output please...)

Revision 1.29  2004/02/28 12:13:03  rasc
minor stuff

Revision 1.28  2004/02/21 00:50:41  rasc
bugfix: MHP AIT descriptors

Revision 1.27  2004/02/20 22:18:40  rasc
DII complete (hopefully)
BIOP::ModuleInfo  (damned, who is spreading infos over several standards???)
maybe someone give me a hint on the selector_byte info!!!
some minor changes...

Revision 1.26  2004/02/16 22:45:37  rasc
small bugfix: crc is 32 bit

Revision 1.25  2004/02/15 22:22:28  rasc
cmd option: -hexdumpbuffer -nohexdumpbuffer

Revision 1.24  2004/01/29 22:34:49  rasc
-sync: default now

Revision 1.23  2004/01/22 22:26:35  rasc
pes_pack_header
section read timeout

Revision 1.22  2004/01/06 14:06:09  rasc
no message

Revision 1.21  2004/01/03 15:40:47  rasc
simple frontend signal status query added "-s signal"

Revision 1.20  2004/01/01 20:09:26  rasc
DSM-CC INT/UNT descriptors
PES-sync changed, TS sync changed,
descriptor scope
other changes

Revision 1.19  2003/12/28 22:53:41  rasc
some minor changes/cleanup

Revision 1.18  2003/12/28 14:00:26  rasc
bugfix: section read from input file
some changes on packet header output

Revision 1.17  2003/12/28 00:01:14  rasc
some minor changes/adds...

Revision 1.16  2003/12/17 23:57:29  rasc
add. hexdump mode, different layout for some purpose
option:  -ph 4

Revision 1.15  2003/12/15 22:29:27  rasc
pidscan improved, problems with max filters on demux

Revision 1.14  2003/12/15 20:09:49  rasc
no message

Revision 1.13  2003/12/14 23:38:46  rasc
- bandwidth reporting for a PID

Revision 1.12  2003/12/10 20:07:15  rasc
minor stuff

Revision 1.11  2003/12/09 21:02:31  rasc
transponder pid-scan improved (should be sufficient now)

Revision 1.10  2003/12/07 23:36:13  rasc
pidscan on transponder
- experimental(!)

Revision 1.9  2003/12/03 20:06:35  obi
- reduced auto* to minimal required checks, obsoletes acinclude.m4
- added version number to configure.ac, removed it from version.h
  (needed for "make dist" anyway)
- removed autoheader dependency

Revision 1.8  2003/11/26 16:27:46  rasc
- mpeg4 descriptors
- simplified bit decoding and output function

Revision 1.7  2003/11/24 23:52:17  rasc
-sync option, some TS and PES stuff;
dsm_addr inactive, may be wrong - due to missing ISO 13818-6

Revision 1.6  2003/11/01 17:05:46  rasc
no message

Revision 1.5  2003/10/16 20:45:47  rasc
no message

Revision 1.4  2003/10/16 19:02:27  rasc
some updates to dvbsnoop...
- small bugfixes
- tables updates from ETR 162

Revision 1.3  2003/07/06 05:28:52  obi
compatibility stuff.. now there is only one version for old and new drivers
which selects the api at configure time

Revision 1.2  2001/10/06 18:19:18  Toerli
Steuerzeichen entfernt. rasc wuerdest du mal bitte nen gescheiten unix-konformen Editor verwenden... windows editoren sind ungeeignet

Revision 1.1  2001/09/30 13:05:20  rasc
dvbsnoop v0.7  -- Commit to CVS


*/


#include "dvbsnoop.h"
#include "cmdline.h"
#include "dvb_api/dvb_api.h"
#include "private/userdefs.h"



static void title (void);
static void usage (void);





/*
  -- set default options and decode cmdline
  -- return 0=abort, 1= ok (&opt set)

*/

int  cmdline_options (int argc, char **argv, OPTION *opt)

{
  char  *s;
  int   i;

  /*
    -- init options
  */

  opt->buffer_hexdump = 1;
  opt->printhex = -1;		// see below
  opt->printdecode = -1;	// see below
  opt->binary_out = 0;
  opt->inpPidFile = (char *) NULL;
  opt->devDemux = DEMUX_DEVICE;
  opt->devDvr = DVR_DEVICE;
  opt->devFE = FRONTEND_DEVICE;
  opt->rd_buffer_size = 0L;	// use default read buffersize
  opt->pid = INVALID_PID;
  opt->filter = 0;
  opt->mask = 0;
  opt->timeout_ms = 0;		// no timeout (0) or default timeout in ms (SECTIONS)
  opt->max_dmx_filter = 0;	// use module default  (pidscan)
  opt->crc = 0;
  opt->spider_pid = 0;
  opt->ts_subdecode = 0;
  opt->rd_packet_count = 0;
  opt->dec_packet_count = 0;
  opt->packet_header_sync = 1;
  opt->packet_mode = SECT;
  opt->time_mode = FULL_TIME;
  opt->hide_copyright= 0;
  opt->help = 0;
  opt->privateProviderStr = (char *)NULL;  // decoding known private tables/descriptors, ProviderStr



  /*
   -- Simple parse of cmdline
  */

  i = 0;
  while (++i < argc) {

     if (!strcmp (argv[i],"-demux")) opt->devDemux = argv[++i];
     else if (!strcmp (argv[i],"-dvr")) opt->devDvr = argv[++i];
     else if (!strcmp (argv[i],"-frontend")) opt->devFE = argv[++i];
     else if (!strcmp (argv[i],"-maxdmx")) opt->max_dmx_filter = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-f")) opt->filter = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-m")) opt->mask = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-crc")) opt->crc = 1;
     else if (!strcmp (argv[i],"-nocrc")) opt->crc = 0;
     else if (!strcmp (argv[i],"-sync")) opt->packet_header_sync = 1;
     else if (!strcmp (argv[i],"-nosync")) opt->packet_header_sync = 0;
     else if (!strcmp (argv[i],"-n")) opt->rd_packet_count = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-N")) opt->dec_packet_count = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-b")) opt->binary_out = 1;
     else if (!strcmp (argv[i],"-ph")) opt->printhex = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-pd")) opt->printdecode = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-npd")) opt->printdecode = 0;
     else if (!strcmp (argv[i],"-hideproginfo")) opt->hide_copyright= 1;
     else if (!strcmp (argv[i],"-timeout")) opt->timeout_ms = str2i(argv[++i]);
     else if (!strcmp (argv[i],"-buffersize")) opt->rd_buffer_size = str2i(argv[++i]) * 1024;
     else if (!strcmp (argv[i],"-tf")) opt->time_mode = FULL_TIME;
     else if (!strcmp (argv[i],"-td")) opt->time_mode = DELTA_TIME;
     else if (!strcmp (argv[i],"-tn")) opt->time_mode = NO_TIME;
     else if (!strcmp (argv[i],"-hexdumpbuffer")) opt->buffer_hexdump = 1;
     else if (!strcmp (argv[i],"-nohexdumpbuffer")) opt->buffer_hexdump = 0;
     else if (!strcmp (argv[i],"-nph")) opt->buffer_hexdump = 0; // old option  use -ph and -nhdb/-hdb
     else if (!strcmp (argv[i],"-help")) opt->help = 1;
     else if (!strcmp (argv[i],"-privateprovider")) opt->privateProviderStr = argv[++i];
     else if (!strcmp (argv[i],"-tssubdecode")) opt->ts_subdecode = 1;
     else if (!strcmp (argv[i],"-spiderpid")) {
	 opt->spider_pid = 1;
	 opt->rd_packet_count = 1;
     } else if (!strcmp (argv[i],"-if")) {
	 opt->inpPidFile = argv[++i];		// input filename
	 if (!opt->inpPidFile) opt->inpPidFile = ""; 
	 if (!strcmp(opt->inpPidFile,"-"))  opt->inpPidFile = "/dev/stdin"; 
	 opt->pid = DUMMY_PID;			// dummy to avoid usage output
     } else if (!strcmp (argv[i],"-s")) {
         s = argv[++i];
	 if (!s ) s = ""; 
         if (!strcmp (s,"sec")) opt->packet_mode = SECT;
         else if (!strcmp (s,"ts")) opt->packet_mode = TS;
         else if (!strcmp (s,"pes")) opt->packet_mode = PES;
         else if (!strcmp (s,"bandwidth")) opt->packet_mode = PIDBANDWIDTH;
         else if (!strcmp (s,"pidscan")) {
		 	opt->packet_mode = PIDSCAN;
			opt->pid = DUMMY_PID;	// dummy to avoid usage output
	 } else if (!strcmp (s,"signal")) {
		 	opt->packet_mode = SCAN_FE_SIGNAL;
			opt->pid = DUMMY_PID;	// dummy to avoid usage output
	 } else if (!strcmp (s,"feinfo")) {
		 	opt->packet_mode = SCAN_FE_INFO;
			opt->pid = DUMMY_PID;	// dummy to avoid usage output
	 } else opt->help = 1;
     } else if (isdigit (argv[i][0])) {
         opt->pid = str2i(argv[i]); 	// PID
	 if (opt->pid > MAX_PID) opt->help = 1;
     } else {
         opt->help = 1;
         break;
     }

  } // while


  /*
   -- standard if no print decode or printhex given
  */

  if (opt->printhex    < 0) opt->printhex = 4;
  if (opt->printdecode < 0) opt->printdecode = 7;


  /*
   -- help ?  (and return abort)
  */

  if (opt->help) {
    usage ();
    printf("\nKnown private providers for private sections and descriptors:\n");
    list_PRIVATE_ProviderStrs ();
    return(0); 
  } 


  /*
    -- set private scope id strings (if specified)
   */
  if (opt->privateProviderStr) {
     set_PRIVATE_ProviderStr (opt->privateProviderStr);
  }



  if ((argc==1) || ((opt->pid > MAX_PID) && (opt->pid != DUMMY_PID)) ) {
    title ();
    printf("For help type 'dvbsnoop -help' ...\n");
    return(0); 
  } 


 return 1;
}






static void title (void)
{
    printf("dvbsnoop  - a dvb/mpeg2 stream analyzer tool\n");
    printf("Version: %s/api-%d  (%s %s)\n",
		    DVBSNOOP_VERSION,DVB_API_VERSION,__DATE__,__TIME__);
    printf("         %s  \n",DVBSNOOP_URL);
    printf("         %s  \n",DVBSNOOP_COPYRIGHT);
    printf("\n");
}



static void usage (void)
{
    title ();

    printf("Usage:   dvbsnoop [opts] pid \n");
    printf("Options:  \n");
    printf("   -demux device: demux device [%s]\n",DEMUX_DEVICE);
    printf("   -dvr device:   dvr device [%s]\n",DVR_DEVICE);
    printf("   -frontend device: frontend   device [%s]\n",FRONTEND_DEVICE);
    printf("   -s type:    snoop type or mode <type>  [-s sec]\n");
    printf("                   stream type: sec, pes or ts\n");
    printf("                   or special scan type:\n");
    printf("                         pidscan = transponder pid scan,\n");
    printf("                         bandwidth = data rate statistics for pid\n");
    printf("                         signal = signal rate statistics \n");
    printf("                         feinfo = frontend information\n");
    printf("                 stream type or pidscan\n");
    printf("   -timeout ms:  section read timeout in ms [-TIMEOUT 0]\n");
    printf("   -maxdmx n:    max demux filters <n> to use in pidscan mode (0=max) [-maxdmx 0]\n");
    printf("   -buffersize kb: read buffersize in KBytes  [-buffersize 0]\n");
    printf("                 (0 = use default read buffer size)\n");
    printf("   -f filter:    filtervalue for 'sec' demux [-f 0]\n");
    printf("   -m mask:      maskvalue for 'sec' demux [-m 0]\n");
    printf("   -crc:         CRC check when reading 'sec' [-nocrc]\n");
    printf("   -nocrc:       No CRC check when reading 'sec' [-nocrc]\n");
    printf("   -sync:        Simple packet header sync when reading 'ts' or 'pes' [-snyc]\n");
    printf("   -nosync:      No header sync when reading 'ts' or 'pes' [-snyc]\n");
    printf("   -n count:     receive/read max. <count> packets (0=no limit) [-n 0]\n");
//    printf("   -N count:     decode max. <count> packets (0=no limit) [-N 0]\n");
    printf("   -spiderpid:   snoop referenced section pids (sets -n 1) \n");
    printf("   -tssubdecode: sub-decode sections or pes from ts stream decoding\n");
    printf("   -b:           binary output of packets (disables other output)\n");
    printf("   -if file:     input file, reads from binary <file> instead of demux device\n");
    printf("   -ph mode:     data hex dump mode, modes: [-ph 4]\n");
    printf("                   0=none, 1=hexdump, 2=hex line 3=ascii line 4=hexdump2\n");
    printf("   -nph:         don't print hex dump of buffer [= -nohexdumpbuffer -ph 0]\n");
    printf("   -hexdumpbuffer:   print hex dump of read buffer [-hexdumpbuffer]\n");
    printf("   -nohexdumpbuffer: don't print hex dump of read buffer [-hexdumpbuffer]\n");
    printf("   -pd verbose:  print stream decode (verbose level 0..9) [-pd 7]\n");
    printf("   -npd:         don't print decoded stream (= -pd 0) \n");
    printf("   -t[n|d|f]:    print timestamp (no, delta, full) [-tf] \n");
    printf("   -privateprovider id: set provider <id> string for decoding private tables and descriptors\n");
    printf("   -hideproginfo: hide copyright and program info header at program start\n");
    printf("   -help:        this usage info...\n");
    printf("\n");
    

 return;
}




// $$$ TODO  commandline handling needs a redesign 

