/***************************************************************************

  CWidget.h

  The Control class

  (c) 2000-2003 Beno� Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __CWIDGET_H
#define __CWIDGET_H


#include "main.h"

#include "gb.qt.h"

#include <qobject.h>
#include <qwidget.h>
#include <qptrdict.h>
#include <qasciidict.h>
#include <qpixmap.h>
#include <qcstring.h>

/* (!) Reporter les modifications de CWIDGET dans gb.qt.h */

typedef
  struct CWIDGET {
    GB_BASE ob;
    QWidget *widget;
    unsigned long flag;
    GB_VARIANT_VALUE tag;
    char *tooltip;
    void *cursor;
    CWIDGET *next;
    CWIDGET *prev;
    long level;
    }
  CWIDGET;

typedef
  struct {
    CWIDGET widget;
    QWidget *container;
    }
  CCONTAINER;

enum {
  WF_DESIGN           = 0x0001,
  WF_FIRST            = 0x0002,
  WF_MENUBAR          = 0x0004,
  WF_PERSISTENT       = 0x0008,
  WF_IN_SHOW          = 0x0010,
  WF_IN_CLOSE         = 0x0020,
  WF_IN_RESIZE        = 0x0040,
  WF_FIXED            = 0x0080,
  WF_NO_EVENT         = 0x0100,
  WF_CLOSED           = 0x0200,
  WF_EXPAND           = 0x0400,
  WF_IGNORE_MOVE      = 0x0800,
  WF_DELETED          = 0x1000,
  WF_LAST             = WF_DELETED
  };

#ifndef __CWIDGET_CPP

extern GB_DESC CWidgetDesc[];
extern CWIDGET *CWIDGET_destroy_list;
extern CWIDGET *CWIDGET_destroy_last;

#else

#define THIS (((CWIDGET *)_object))
#define WIDGET QWIDGET(_object)

#endif

#define QWIDGET(object) (((CWIDGET *)object)->widget)
#define CONTAINER(_ob) CWidget::getContainerWidget((CCONTAINER *)_ob)

DECLARE_METHOD(CWIDGET_delete);
DECLARE_PROPERTY(CWIDGET_tag);
DECLARE_PROPERTY(CWIDGET_border_full);
DECLARE_PROPERTY(CWIDGET_border_simple);
DECLARE_PROPERTY(CWIDGET_scrollbar);
DECLARE_PROPERTY(CWIDGET_design);
DECLARE_PROPERTY(CWIDGET_enabled);
DECLARE_PROPERTY(CWIDGET_font);

#define CWIDGET_set_flag(wid, f) (((CWIDGET *)wid)->flag |= f)
#define CWIDGET_clear_flag(wid, f) (((CWIDGET *)wid)->flag &= ~f)
#define CWIDGET_test_flag(wid, f) ((((CWIDGET *)wid)->flag & f) != 0)

#define GET_SENDER(_ob)   CWIDGET *_ob = CWidget::get((QObject *)sender())

#define CWIDGET_PROPERTIES QT_WIDGET_PROPERTIES

#define RAISE_EVENT(_event) \
{ \
  GET_SENDER(ob); \
\
  if (ob == NULL) \
    return; \
\
  GB.Raise(ob, _event, 0); \
}

#define ENUM(type)  (*((type *)GB.GetEnum()))

#define EVENT_CLOSE (QEvent::User)
#define EVENT_POST ((QEvent::Type)(QEvent::User + 1))
#define EVENT_EXPAND ((QEvent::Type)(QEvent::User + 2))

#define ALIGN_MASK (Qt::AlignLeft | Qt::AlignRight | Qt::AlignTop | Qt::AlignBottom | Qt::AlignCenter)
#define ALIGN_HMASK (Qt::AlignLeft | Qt::AlignRight | Qt::AlignHCenter)
#define ALIGN_VMASK (Qt::AlignTop | Qt::Bottom | Qt::AlignVCenter)

#define SET_WIDGET(_ob, _wid) (((CWIDGET *)_ob)->widget = (_wid))
#define CLEAR_WIDGET(_ob) SET_WIDGET(_ob, 0)

void CWIDGET_new(QWidget *w, void *object, char *klass = NULL,
                 bool no_filter = false, bool no_tag = false);
int CWIDGET_check(void *object);
QString CWIDGET_Utf8ToQString(GB_STRING *str);
void CWIDGET_destroy(CWIDGET *);

#ifndef __CWIDGET_CPP
extern
#endif
long
//EVENT_Move,
//EVENT_Resize,
EVENT_MouseDown,
EVENT_MouseUp,
EVENT_MouseMove,
EVENT_MouseWheel,
EVENT_DblClick,
EVENT_KeyPress,
EVENT_KeyRelease,
EVENT_Enter,
EVENT_Leave,
EVENT_GotFocus,
EVENT_LostFocus,
EVENT_Menu,
EVENT_Drag,
EVENT_DragMove,
EVENT_Drop;


class CWidget : public QObject
{
  Q_OBJECT

public:

  static void add(QObject *, void *, bool no_filter);
  static CWIDGET *get(QObject *);
  static CWIDGET *getReal(QObject *);

  static QWidget *getContainerWidget(CCONTAINER *object);

  //static void setName(CWIDGET *, const char *);
  static void installFilter(QObject *);
  static void removeFilter(QObject *);

  //static const char *getProperties(const void *klass);
  //static void setProperties(const void *klass, const char *prop);

  static void resetTooltip(CWIDGET *);
  static void removeFocusPolicy(QWidget *);

public slots:

  void destroy(void);

protected:

  bool eventFilter(QObject *, QEvent *);

private:

  static bool real;

  static CWidget manager;
  static CWIDGET *enter;
  static QPtrDict<CWIDGET> dict;
};

#endif
