/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-glib.h"



static void builtin_module_init (void);

static gpointer create_panel_quark_list (gpointer data,
					 gpointer func_data,
					 gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_quark_list (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-quark-list";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-quark-list",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  create_panel_quark_list,
				  NULL);
}



enum
{
  COLUMN_0,

  COLUMN_GQUARK,
  COLUMN_STRING,

  NUM_COLUMNS
};

static GInspectorElementListColumnInfo columns[NUM_COLUMNS] =
{
  G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0,

  { COLUMN_GQUARK,	  "GQuark",		"guint",	"text" },
  { COLUMN_STRING,	  "String",		"gchararray",	"text" },
};


static void
append_row (GtkListStore *list_store,
	    GQuark        quark)
{
  GtkTreeIter tree_iter;
  
  gtk_list_store_append (list_store, &tree_iter);

  g_inspector_element_list_set_row_element (list_store, &tree_iter,
					    G_INSPECTOR_ELEMENT_TYPE_MISC,
					    GQUARK_TO_POINTER (quark));

  gtk_list_store_set (list_store, &tree_iter,
		      COLUMN_GQUARK, quark,
		      COLUMN_STRING, g_quark_to_string (quark),
		      -1);
}

static void
create_list (GtkListStore *list_store)
{
  int i;
  GQuark quark;


  for (i = 1; g_quark_to_string(i) != NULL; ++i)
    {
      quark = i;

      append_row (list_store, quark);
    }
}

static void
update (GInspectorElementList *element_list,
	gpointer               user_data)
{
  GtkListStore *list_store;

  list_store = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (element_list)));

  gtk_list_store_clear (list_store);
  create_list (list_store);
}



static gpointer
create_panel_quark_list (gpointer data,
			 gpointer func_data,
			 gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_list;


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "GQuark List");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_list = g_inspector_element_list_new (columns,
						 G_N_ELEMENTS (columns));
    g_signal_connect (element_list,
		      "update",
		      G_CALLBACK (update),
		      NULL);

    gtk_container_add (GTK_CONTAINER (scrolled_window),
		       element_list);

    g_inspector_panel_attach_element_list (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_LIST (element_list));
  }


  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}
