/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-preload-manager.h"

#include <string.h>


static GList *preload_module_list = NULL;


void
g_inspector_preload_register_module (const GInspectorPreloadModuleInfo *preload_module_info)
{
  g_return_if_fail (preload_module_info != NULL);
  g_return_if_fail (preload_module_info->name != NULL);

  preload_module_list = g_list_append (preload_module_list,
				       (gpointer)preload_module_info);
}

GList*
g_inspector_preload_get_module_list (void)
{
  return preload_module_list;
}

GInspectorPreloadModuleInfo*
g_inspector_preload_find_module (const gchar *name)
{
  GInspectorPreloadModuleInfo *tmp_preload_module_info;
  GInspectorPreloadModuleInfo *preload_module_info;
  GList *tmp;


  g_return_val_if_fail (name != NULL, NULL);


  preload_module_info = NULL;


  tmp = preload_module_list;
  while (tmp != NULL)
    {
      tmp_preload_module_info = tmp->data;
      tmp = g_list_next (tmp);

      if (strcmp (tmp_preload_module_info->name, name) == 0)
	{
	  preload_module_info = tmp_preload_module_info;
	  break;
	}
    }


  return preload_module_info;
}


void
g_inspector_preload_init_modules (void)
{
  GInspectorPreloadModuleInfo *preload_module_info;
  GList *tmp;

  tmp = preload_module_list;
  while (tmp != NULL)
    {
      preload_module_info = tmp->data;
      tmp = g_list_next (tmp);
	
      g_print ("preload: %s\n", preload_module_info->name);

      if (preload_module_info->init != NULL)
	{
	  (* preload_module_info->init) ();
	}
    }
}

void
g_inspector_preload_activate_modules (void)
{
  GInspectorPreloadModuleInfo *preload_module_info;
  GList *tmp;

  tmp = preload_module_list;
  while (tmp != NULL)
    {
      preload_module_info = tmp->data;
      tmp = g_list_next (tmp);
	
      if (preload_module_info->activate != NULL)
	{
	  (* preload_module_info->activate) ();
	}
    }
}

void
g_inspector_preload_deactivate_modules (void)
{
  GInspectorPreloadModuleInfo *preload_module_info;
  GList *tmp;

  tmp = preload_module_list;
  while (tmp != NULL)
    {
      preload_module_info = tmp->data;
      tmp = g_list_next (tmp);
	
      if (preload_module_info->deactivate != NULL)
	{
	  (* preload_module_info->deactivate) ();
	}
    }
}
