#ifndef STR_UTILS_H
#define STR_UTILS_H

#include "gliv.h"

/*
 * The magic to find a '\0' in a long int is taken from the glibc.
 * See sysdeps/generic/strlen.c in the glibc sources to have the
 * explanation.
 * Actually it also finds 0x80, that's why we double check when
 * HAS_ZERO() finds something.
 */
#define INIT_MAGIC()                                                \
    do {                                                            \
        himagic = 0x80808080L;                                      \
        lomagic = 0x01010101L;                                      \
                                                                    \
        if (sizeof(gulong) > 4) {                                   \
            /* 64-bit */                                            \
            himagic = ((himagic << 16) << 16) | himagic;            \
            lomagic = ((lomagic << 16) << 16) | lomagic;            \
            magic_bits = ((0x7efefefeL << 16) << 16) | 0xfefefeffL; \
        } else                                                      \
            magic_bits = 0x7efefeffL;                               \
    } while (0)

#define HAS_ZERO(longint) ((((longint) + magic_bits) ^ ~longint) & ~magic_bits)

const gchar *filename_to_utf8(const gchar * str);
gchar *clean_filename(const gchar * filename);

#endif
