/* $Id: inbuffer.h 223598 2020-11-21 04:19:17Z twu $ */
#ifndef INBUFFER_INCLUDED
#define INBUFFER_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"		/* For HAVE_ZLIB, HAVE_BZLIB */
#endif

#include <stdio.h>
#include "bool.h"
#include "outbuffer.h"
#include "request.h"

#ifdef GSNAP
#include "shortread.h"
#else
#include "sequence.h"
#include "genome.h"
#endif

#ifdef HAVE_ZLIB
#include <zlib.h>
#endif

#ifdef HAVE_BZLIB
#include "bzip2.h"
#endif


#define T Inbuffer_T
typedef struct T *T;

extern void
Inbuffer_setup (bool filter_if_both_p_in);

#ifndef GSNAP
extern T
Inbuffer_cmdline (char *queryseq, int querylength, Genome_T genome, Genome_T genomealt);
#endif

extern T
Inbuffer_new (int nextchar,
	      FILE *input,
#ifdef GSNAP
	      FILE *input2,
#ifdef HAVE_ZLIB
	      gzFile gzipped, gzFile gzipped2,
#endif
#ifdef HAVE_BZLIB
	      Bzip2_T bzipped, Bzip2_T bzipped2,
#endif
	      bool interleavedp,
#endif
	      char *read_files_command, char **files, int nfiles, unsigned int nspaces,
	      bool user_pairalign_p, int part_modulus, int part_interval);

extern void
Inbuffer_set_outbuffer (T this, Outbuffer_T outbuffer);

extern void
Inbuffer_free (T *old);

extern unsigned int
Inbuffer_fill_init (T this);

extern Request_T
Inbuffer_get_request (T this);

#undef T
#endif

