/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_DIALOG_H
#define GM_DIALOG_H

#define B_OK     1 << 0
#define B_YES    1 << 1
#define B_NO     1 << 2
#define B_CANCEL 1 << 3
#define B_DONE   1 << 4
#define B_ABORT  1 << 5
#define B_RETRY  1 << 6
#define B_IGNORE 1 << 7

#define B_COUNT  8

/* Pop up a dialog with the buttons |ed (logigly orred),
 * returns the pressed button
 */
int  gm_dialog_popup     (const char *title, const char *text, 
			  int buttons, int modal);

char *gm_dialog_text(const char *title, const char *text, const char *def,
		     int modal);

/* Displays a message */
void gm_dialog_popup_only(const char *title, const char *text, 
			  int modal);

#endif /* GM_DIALOG_H */
