/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "properties.h"
#include "configdb.h"
#include "rcfile.h"

#include <stdlib.h>
#ifdef ZVT
#include <zvt/zvtterm.h>
#endif

void gm_properties_apply(world *w, properties_t *new) {
#ifdef ZLIB
    int tmp;
#endif
    properties_t *old = w->p;
    w->p = new;

#ifdef ZLIB
    if(new->log_use != old->log_use || new->log_type != old->log_type ||
       new->compressed_logs != old->compressed_logs) {
        tmp = new->compressed_logs;
        new->compressed_logs = old->compressed_logs;
        gm_world_close_log(w);
        new->compressed_logs = tmp;
        gm_world_open_log(w);
    }
#else
    if(new->log_use != old->log_use || new->log_type != old->log_type) {
        gm_world_close_log(w);
        gm_world_open_log(w);
    }
#endif

    gm_properties_free(old);
}

properties_t *gm_properties_copy(properties_t *from) {
    properties_t *p = g_malloc(sizeof(properties_t));

    p->name      = g_strdup(from->name);
    p->hostname  = g_strdup(from->hostname);
    p->port      = from->port;
    p->autologin = from->autologin;
    p->savelogin = from->savelogin;
    p->username  = g_strdup(from->username);
    p->password  = g_strdup(from->password);
    p->input_height = from->input_height;
    p->userlist_width = from->userlist_width;

    p->log_use         = from->log_use;
    p->log_input       = from->log_input;
    p->log_color       = from->log_color;
    p->log_type        = from->log_type;
#ifdef ZLIB
    p->compressed_logs = from->compressed_logs;
#endif

    return p;
}

void gm_properties_store(properties_t *p, const char *filename) {
    ConfigDB *db;

    db = configdb_load(filename, FALSE);

    db = configdb_set_string(db, HOSTNAME,     p->hostname);
    db = configdb_set_int   (db, PORT,         p->port);
    db = configdb_set_int   (db, AUTOLOGIN,    p->autologin);
    db = configdb_set_int   (db, SAVELOGIN,    p->savelogin);
    if (p->autologin || p->savelogin) {
        db = configdb_set_string(db, USERNAME, p->username);
        db = configdb_set_string(db, PASSWORD, p->password);
    } else {
        db = configdb_delete(db, USERNAME);
        db = configdb_delete(db, PASSWORD);
    }
    db = configdb_set_int(db, INPUT_HEIGHT, p->input_height);
    db = configdb_set_int(db, USERLIST_WIDTH, p->userlist_width);

    db = configdb_set_int(db, LOG_USE,         p->log_use);
    db = configdb_set_int(db, LOG_INPUT,       p->log_input);
    db = configdb_set_int(db, LOG_COLOR,       p->log_color);
    db = configdb_set_int(db, LOG_TYPE,        p->log_type);
#ifdef ZLIB
    db = configdb_set_int(db, COMPRESSED_LOGS, p->compressed_logs);
#endif

    configdb_store(db, filename, FALSE);
    configdb_free(db);
}

properties_t *gm_properties_load(const char *filename) {
    properties_t *p = g_malloc(sizeof(properties_t));
    ConfigDB *db = configdb_load(filename, FALSE);

    p->name = NULL;
    p->hostname  = configdb_get_string(db, HOSTNAME,  _HOSTNAME);
    p->port      = configdb_get_int   (db, PORT,      _PORT);
    p->autologin = configdb_get_int   (db, AUTOLOGIN, _AUTOLOGIN);
    p->savelogin = configdb_get_int   (db, SAVELOGIN, _SAVELOGIN);
    p->username  = configdb_get_string(db, USERNAME,  _USERNAME);
    p->password  = configdb_get_string(db, PASSWORD,  _PASSWORD);
    p->input_height = configdb_get_int(db, INPUT_HEIGHT, _INPUT_HEIGHT);
    p->userlist_width = configdb_get_int(db, USERLIST_WIDTH, _USERLIST_WIDTH);

    p->log_use         = configdb_get_int(db, LOG_USE,   _LOG_USE);
    p->log_input       = configdb_get_int(db, LOG_INPUT, _LOG_INPUT);
    p->log_color       = configdb_get_int(db, LOG_COLOR, _LOG_COLOR);
    p->log_type        = configdb_get_int(db, LOG_TYPE,  _LOG_TYPE);
#ifdef ZLIB
    p->compressed_logs = configdb_get_int(db,COMPRESSED_LOGS,_COMPRESSED_LOGS);
#endif

    configdb_free(db);
    return p;
}

void gm_properties_free(properties_t *p) {
    g_free(p->name);
    g_free(p->hostname);
    g_free(p->username);
    g_free(p->password);
    
    g_free(p);
}
