/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "config.h"

#include "world.h"
#include "window.h"
#include "menu.h"
#include "toolbar.h"
#include "notebook.h"
#include "statusbar.h"
#include "settings.h"

GtkWidget     *main_window;
GtkAccelGroup *accel_group;

void gm_window_really_close(GtkWidget *window, GdkEvent *event, void *data);

GtkWidget *gm_window_get_window() {
    return main_window;
}

void window_resized(GtkWidget *window, GtkAllocation *allocation) {
    if(debug) printf("Main window resized to %d x %d\n",
                     allocation->height, allocation->width);
    settings->window_height = allocation->height;
    settings->window_width  = allocation->width;
}

GtkWidget *gm_window_create_and_show() {
    GtkWidget *window, *w;
    GtkWidget *vbox;

    if(debug) printf("Creating window\n");

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    if(settings->save_window_size) {
        gtk_window_set_default_size(GTK_WINDOW(window), settings->window_width,
                                    settings->window_height);
    }
    gtk_signal_connect(GTK_OBJECT(window), "delete_event", 
                       GTK_SIGNAL_FUNC(gm_window_close), NULL);
    gtk_signal_connect(GTK_OBJECT(window), "size_allocate", 
                       GTK_SIGNAL_FUNC(window_resized), NULL);
    gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
    gtk_window_set_title(GTK_WINDOW(window), "gmoo-"VERSION);
    gtk_window_set_wmclass(GTK_WINDOW(window), "gmoo_main_window",
                           "gmoo");

    accel_group = gtk_accel_group_new();
    gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox);
    gtk_container_add(GTK_CONTAINER(window), vbox);

    /* This needs to be done, to have a realized window for the creations of
     * the pixmaps in the following functions
     */
    main_window = window;
    gtk_widget_show(window);

    gtk_box_pack_start(GTK_BOX(vbox), gm_menu_create(),          FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), (w = gm_toolbar_create()), FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), gm_notebook_create(),      TRUE,  TRUE,  0);
    gtk_box_pack_start(GTK_BOX(vbox), gm_statusbar_create(),     FALSE, FALSE, 0);

    /* Extemely dirty hack - just ignore it. */
    if (!settings->toolbar)
	    gtk_widget_hide(w);

    return window;
}

void load_main_window_icon() {
    GdkPixmap *icon;
    GdkBitmap *mask;
#include "../share/gmoo.xpm"

    icon = gdk_pixmap_create_from_xpm_d(main_window->window,
					&mask,
					&main_window->style->
					  bg[GTK_STATE_NORMAL],
					gmoo_xpm);
    gdk_window_set_icon(main_window->window, NULL, icon, mask);
    gdk_window_set_icon_name(main_window->window, "gmoo");
}

void gm_window_init() {
    gm_window_create_and_show();

    gm_settings_update();

    load_main_window_icon();
}




/* Callbacks
 */

void gm_window_close() {
    if(gm_notebook_ok_to_close()) {
        gm_notebook_close();
        gtk_main_quit();
    }
}

void gm_window_really_close(GtkWidget *window, GdkEvent *event, void *data) {
    gtk_main_quit();
}


/* Other functions
 */

GdkWindow *gm_window_get_GdkWindow() {
    return main_window->window;
}

GdkColor *gm_window_get_background_color() { 
    return &main_window->style->bg[GTK_STATE_NORMAL];
}

GtkAccelGroup *gm_window_get_accel_group() {
    return accel_group;
}
