/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_CONF2_H
#define GNUT_CONF2_H

#include "hash.h"

typedef struct {
  char *ckp_key;
  char *ckp_val;
} conf_key_pair;

#ifdef __cplusplus
extern "C" {
#endif

  extern conf_key_pair configuration_pairs[];

  void conf_cache_entry(char *key);
  int conf_init();
  int conf_get_int(char *);
  char * conf_get_str(char *);
  int conf_set_int(char *, int);
  int conf_set_str(char *, char *);
  int conf_set_str_len(char *, char *, int len);

  extern Gnut_Hash *conf_hash;

  extern int gc_auto_forget;
  extern int gc_cache_parallel;
  extern int gc_cache_refresh;
  extern int gc_debug_opts;
  extern int gc_eval_echo;
  extern int gc_hide_pathname;
  extern int gc_host_list_size;
  extern int gc_max_uploads;
  extern int gc_munge;
  extern int gc_no_rfc_1597;
  extern int gc_score_available;
  extern int gc_score_did_upload;
  extern int gc_score_did_receive;
  extern int gc_search_log_all;
  extern int gc_search_max_size; /* 0.4.28.c27 */
  extern int gc_search_min_rating;
  extern int gc_search_min_size;
  extern uint32 gc_speed;
  extern int gc_strict_search;
  extern int gc_ttl;
  extern FILE *gc_search_log;
  extern FILE *gc_transferlog;
  extern int gc_verbose;

  /* Allow this client to search on behalf of someone who has the
     misfortune of not having their own gnut client. */
#define GNUT_HTTP_SEARCH 1
#define GNUT_HTTP_FILE_LIST 1

#ifdef __cplusplus
}
#endif

#endif
