// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package ideahub provides access to the Idea Hub API.
//
// For product documentation, see: https://console.cloud.google.com/apis/library/ideahub.googleapis.com
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/ideahub/v1beta"
//   ...
//   ctx := context.Background()
//   ideahubService, err := ideahub.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   ideahubService, err := ideahub.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   ideahubService, err := ideahub.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package ideahub // import "google.golang.org/api/ideahub/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "ideahub:v1beta"
const apiName = "ideahub"
const apiVersion = "v1beta"
const basePath = "https://ideahub.googleapis.com/"
const mtlsBasePath = "https://ideahub.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Platforms = NewPlatformsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Platforms *PlatformsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewPlatformsService(s *Service) *PlatformsService {
	rs := &PlatformsService{s: s}
	rs.Properties = NewPlatformsPropertiesService(s)
	return rs
}

type PlatformsService struct {
	s *Service

	Properties *PlatformsPropertiesService
}

func NewPlatformsPropertiesService(s *Service) *PlatformsPropertiesService {
	rs := &PlatformsPropertiesService{s: s}
	rs.IdeaActivities = NewPlatformsPropertiesIdeaActivitiesService(s)
	rs.IdeaStates = NewPlatformsPropertiesIdeaStatesService(s)
	rs.Ideas = NewPlatformsPropertiesIdeasService(s)
	rs.Locales = NewPlatformsPropertiesLocalesService(s)
	rs.TopicStates = NewPlatformsPropertiesTopicStatesService(s)
	return rs
}

type PlatformsPropertiesService struct {
	s *Service

	IdeaActivities *PlatformsPropertiesIdeaActivitiesService

	IdeaStates *PlatformsPropertiesIdeaStatesService

	Ideas *PlatformsPropertiesIdeasService

	Locales *PlatformsPropertiesLocalesService

	TopicStates *PlatformsPropertiesTopicStatesService
}

func NewPlatformsPropertiesIdeaActivitiesService(s *Service) *PlatformsPropertiesIdeaActivitiesService {
	rs := &PlatformsPropertiesIdeaActivitiesService{s: s}
	return rs
}

type PlatformsPropertiesIdeaActivitiesService struct {
	s *Service
}

func NewPlatformsPropertiesIdeaStatesService(s *Service) *PlatformsPropertiesIdeaStatesService {
	rs := &PlatformsPropertiesIdeaStatesService{s: s}
	return rs
}

type PlatformsPropertiesIdeaStatesService struct {
	s *Service
}

func NewPlatformsPropertiesIdeasService(s *Service) *PlatformsPropertiesIdeasService {
	rs := &PlatformsPropertiesIdeasService{s: s}
	return rs
}

type PlatformsPropertiesIdeasService struct {
	s *Service
}

func NewPlatformsPropertiesLocalesService(s *Service) *PlatformsPropertiesLocalesService {
	rs := &PlatformsPropertiesLocalesService{s: s}
	return rs
}

type PlatformsPropertiesLocalesService struct {
	s *Service
}

func NewPlatformsPropertiesTopicStatesService(s *Service) *PlatformsPropertiesTopicStatesService {
	rs := &PlatformsPropertiesTopicStatesService{s: s}
	return rs
}

type PlatformsPropertiesTopicStatesService struct {
	s *Service
}

// GoogleSearchIdeahubV1betaAvailableLocale: Represents locales that are
// available for a web property.
type GoogleSearchIdeahubV1betaAvailableLocale struct {
	// Locale: A string in BCP 47 format, without a resource prefix.
	Locale string `json:"locale,omitempty"`

	// Name: A string in BCP 47 format, prefixed with the platform and
	// property name, and "locales/". Format:
	// platforms/{platform}/properties/{property}/locales/{locale}
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Locale") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locale") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaAvailableLocale) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaAvailableLocale
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleSearchIdeahubV1betaIdea: A single Idea that we want to show the
// end user.
type GoogleSearchIdeahubV1betaIdea struct {
	// Name: Unique identifier for the idea. Format: ideas/{ideaId}
	Name string `json:"name,omitempty"`

	// Text: The idea’s text.
	Text string `json:"text,omitempty"`

	// Topics: The Topics that match the idea.
	Topics []*GoogleSearchIdeahubV1betaTopic `json:"topics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaIdea) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaIdea
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleSearchIdeahubV1betaIdeaActivity: An idea activity entry.
type GoogleSearchIdeahubV1betaIdeaActivity struct {
	// Ideas: The Idea IDs for this entry. If empty, topics should be set.
	Ideas []string `json:"ideas,omitempty"`

	// Name: Unique identifier for the idea activity. The name is ignored
	// when creating an idea activity. Format:
	// platforms/{platform}/properties/{property}/ideaActivities/{idea_activi
	// ty}
	Name string `json:"name,omitempty"`

	// Topics: The Topic IDs for this entry. If empty, ideas should be set.
	Topics []string `json:"topics,omitempty"`

	// Type: The type of activity performed.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - An unspecified, unknown type of idea activity.
	//   "POST_DRAFTED" - An idea activity type indicating a post has been
	// drafted.
	//   "POST_PUBLISHED" - An idea activity type indicating a post has been
	// published.
	//   "POST_DELETED" - An idea activity type indicating a post has been
	// deleted.
	//   "POST_UNPUBLISHED" - An idea activity type indicating a post has
	// been unpublished.
	Type string `json:"type,omitempty"`

	// Uri: The uri the activity relates to.
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Ideas") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ideas") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaIdeaActivity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaIdeaActivity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleSearchIdeahubV1betaIdeaState: Represents idea state specific to
// a web property.
type GoogleSearchIdeahubV1betaIdeaState struct {
	// Dismissed: Whether the idea is dismissed.
	Dismissed bool `json:"dismissed,omitempty"`

	// Name: Unique identifier for the idea state. Format:
	// platforms/{platform}/properties/{property}/ideaStates/{idea_state}
	Name string `json:"name,omitempty"`

	// Saved: Whether the idea is saved.
	Saved bool `json:"saved,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Dismissed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dismissed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaIdeaState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaIdeaState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleSearchIdeahubV1betaListAvailableLocalesResponse: Response for
// whether ideas are available for a given web property on a platform,
// for the currently logged-in user.
type GoogleSearchIdeahubV1betaListAvailableLocalesResponse struct {
	// AvailableLocales: Locales for which ideas are available for the given
	// Creator.
	AvailableLocales []*GoogleSearchIdeahubV1betaAvailableLocale `json:"availableLocales,omitempty"`

	// NextPageToken: A token that can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AvailableLocales") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailableLocales") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaListAvailableLocalesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaListAvailableLocalesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleSearchIdeahubV1betaListIdeasResponse struct {
	// Ideas: Results for the ListIdeasRequest.
	Ideas []*GoogleSearchIdeahubV1betaIdea `json:"ideas,omitempty"`

	// NextPageToken: Used to fetch the next page in a subsequent request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Ideas") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ideas") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaListIdeasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaListIdeasResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleSearchIdeahubV1betaTopic: Represents a Topic umbrella for a
// list of questions that a Creator may want to respond to.
type GoogleSearchIdeahubV1betaTopic struct {
	// DisplayName: String displayed to the creator indicating the name of
	// the Topic.
	DisplayName string `json:"displayName,omitempty"`

	// Mid: The mID of the topic.
	Mid string `json:"mid,omitempty"`

	// Name: Unique identifier for the topic. Format: topics/{topic}
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaTopic) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaTopic
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleSearchIdeahubV1betaTopicState: Represents topic state specific
// to a web property.
type GoogleSearchIdeahubV1betaTopicState struct {
	// Dismissed: Whether the topic is dismissed.
	Dismissed bool `json:"dismissed,omitempty"`

	// Name: Unique identifier for the topic state. Format:
	// platforms/{platform}/properties/{property}/topicStates/{topic_state}
	Name string `json:"name,omitempty"`

	// Saved: Whether the topic is saved.
	Saved bool `json:"saved,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Dismissed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dismissed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleSearchIdeahubV1betaTopicState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSearchIdeahubV1betaTopicState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "ideahub.platforms.properties.ideaActivities.create":

type PlatformsPropertiesIdeaActivitiesCreateCall struct {
	s                                     *Service
	parent                                string
	googlesearchideahubv1betaideaactivity *GoogleSearchIdeahubV1betaIdeaActivity
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates an idea activity entry.
//
// - parent: The parent resource where this idea activity will be
//   created. Format: platforms/{platform}/property/{property}.
func (r *PlatformsPropertiesIdeaActivitiesService) Create(parent string, googlesearchideahubv1betaideaactivity *GoogleSearchIdeahubV1betaIdeaActivity) *PlatformsPropertiesIdeaActivitiesCreateCall {
	c := &PlatformsPropertiesIdeaActivitiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlesearchideahubv1betaideaactivity = googlesearchideahubv1betaideaactivity
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlatformsPropertiesIdeaActivitiesCreateCall) Fields(s ...googleapi.Field) *PlatformsPropertiesIdeaActivitiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlatformsPropertiesIdeaActivitiesCreateCall) Context(ctx context.Context) *PlatformsPropertiesIdeaActivitiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlatformsPropertiesIdeaActivitiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlatformsPropertiesIdeaActivitiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlesearchideahubv1betaideaactivity)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/ideaActivities")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ideahub.platforms.properties.ideaActivities.create" call.
// Exactly one of *GoogleSearchIdeahubV1betaIdeaActivity or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleSearchIdeahubV1betaIdeaActivity.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PlatformsPropertiesIdeaActivitiesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleSearchIdeahubV1betaIdeaActivity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleSearchIdeahubV1betaIdeaActivity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an idea activity entry.",
	//   "flatPath": "v1beta/platforms/{platformsId}/properties/{propertiesId}/ideaActivities",
	//   "httpMethod": "POST",
	//   "id": "ideahub.platforms.properties.ideaActivities.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this idea activity will be created. Format: platforms/{platform}/property/{property}",
	//       "location": "path",
	//       "pattern": "^platforms/[^/]+/properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/ideaActivities",
	//   "request": {
	//     "$ref": "GoogleSearchIdeahubV1betaIdeaActivity"
	//   },
	//   "response": {
	//     "$ref": "GoogleSearchIdeahubV1betaIdeaActivity"
	//   }
	// }

}

// method id "ideahub.platforms.properties.ideaStates.patch":

type PlatformsPropertiesIdeaStatesPatchCall struct {
	s                                  *Service
	nameid                             string
	googlesearchideahubv1betaideastate *GoogleSearchIdeahubV1betaIdeaState
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Update an idea state resource.
//
// - name: Unique identifier for the idea state. Format:
//   platforms/{platform}/properties/{property}/ideaStates/{idea_state}.
func (r *PlatformsPropertiesIdeaStatesService) Patch(nameid string, googlesearchideahubv1betaideastate *GoogleSearchIdeahubV1betaIdeaState) *PlatformsPropertiesIdeaStatesPatchCall {
	c := &PlatformsPropertiesIdeaStatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googlesearchideahubv1betaideastate = googlesearchideahubv1betaideastate
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *PlatformsPropertiesIdeaStatesPatchCall) UpdateMask(updateMask string) *PlatformsPropertiesIdeaStatesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlatformsPropertiesIdeaStatesPatchCall) Fields(s ...googleapi.Field) *PlatformsPropertiesIdeaStatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlatformsPropertiesIdeaStatesPatchCall) Context(ctx context.Context) *PlatformsPropertiesIdeaStatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlatformsPropertiesIdeaStatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlatformsPropertiesIdeaStatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlesearchideahubv1betaideastate)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ideahub.platforms.properties.ideaStates.patch" call.
// Exactly one of *GoogleSearchIdeahubV1betaIdeaState or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleSearchIdeahubV1betaIdeaState.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PlatformsPropertiesIdeaStatesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleSearchIdeahubV1betaIdeaState, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleSearchIdeahubV1betaIdeaState{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update an idea state resource.",
	//   "flatPath": "v1beta/platforms/{platformsId}/properties/{propertiesId}/ideaStates/{ideaStatesId}",
	//   "httpMethod": "PATCH",
	//   "id": "ideahub.platforms.properties.ideaStates.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Unique identifier for the idea state. Format: platforms/{platform}/properties/{property}/ideaStates/{idea_state}",
	//       "location": "path",
	//       "pattern": "^platforms/[^/]+/properties/[^/]+/ideaStates/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleSearchIdeahubV1betaIdeaState"
	//   },
	//   "response": {
	//     "$ref": "GoogleSearchIdeahubV1betaIdeaState"
	//   }
	// }

}

// method id "ideahub.platforms.properties.ideas.list":

type PlatformsPropertiesIdeasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List ideas for a given Creator and filter and sort options.
//
// - parent: If defined, specifies the creator for which to filter by.
//   Format: publishers/{publisher}/properties/{property}.
func (r *PlatformsPropertiesIdeasService) List(parent string) *PlatformsPropertiesIdeasListCall {
	c := &PlatformsPropertiesIdeasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Allows filtering.
// Supported syntax: * Filter expressions are made up of one or more
// restrictions. * Restrictions are implicitly combined, as if the `AND`
// operator was always used. The `OR` operator is currently unsupported.
// * Supported functions: - `saved(bool)`: If set to true, fetches only
// saved ideas. If set to false, fetches all except saved ideas. Can't
// be simultaneously used with `dismissed(bool)`. - `dismissed(bool)`:
// If set to true, fetches only dismissed ideas. Can't be simultaneously
// used with `saved(bool)`. The `false` value is currently unsupported.
// Examples: * `saved(true)` * `saved(false)` * `dismissed(true)` The
// length of this field should be no more than 500 characters.
func (c *PlatformsPropertiesIdeasListCall) Filter(filter string) *PlatformsPropertiesIdeasListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order semantics
// described below.
func (c *PlatformsPropertiesIdeasListCall) OrderBy(orderBy string) *PlatformsPropertiesIdeasListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of ideas per page. If unspecified, at most 10 ideas will be returned.
// The maximum value is 2000; values above 2000 will be coerced to 2000.
func (c *PlatformsPropertiesIdeasListCall) PageSize(pageSize int64) *PlatformsPropertiesIdeasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Used to fetch next
// page.
func (c *PlatformsPropertiesIdeasListCall) PageToken(pageToken string) *PlatformsPropertiesIdeasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlatformsPropertiesIdeasListCall) Fields(s ...googleapi.Field) *PlatformsPropertiesIdeasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PlatformsPropertiesIdeasListCall) IfNoneMatch(entityTag string) *PlatformsPropertiesIdeasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlatformsPropertiesIdeasListCall) Context(ctx context.Context) *PlatformsPropertiesIdeasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlatformsPropertiesIdeasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlatformsPropertiesIdeasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/ideas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ideahub.platforms.properties.ideas.list" call.
// Exactly one of *GoogleSearchIdeahubV1betaListIdeasResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleSearchIdeahubV1betaListIdeasResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PlatformsPropertiesIdeasListCall) Do(opts ...googleapi.CallOption) (*GoogleSearchIdeahubV1betaListIdeasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleSearchIdeahubV1betaListIdeasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List ideas for a given Creator and filter and sort options.",
	//   "flatPath": "v1beta/platforms/{platformsId}/properties/{propertiesId}/ideas",
	//   "httpMethod": "GET",
	//   "id": "ideahub.platforms.properties.ideas.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Allows filtering. Supported syntax: * Filter expressions are made up of one or more restrictions. * Restrictions are implicitly combined, as if the `AND` operator was always used. The `OR` operator is currently unsupported. * Supported functions: - `saved(bool)`: If set to true, fetches only saved ideas. If set to false, fetches all except saved ideas. Can't be simultaneously used with `dismissed(bool)`. - `dismissed(bool)`: If set to true, fetches only dismissed ideas. Can't be simultaneously used with `saved(bool)`. The `false` value is currently unsupported. Examples: * `saved(true)` * `saved(false)` * `dismissed(true)` The length of this field should be no more than 500 characters.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Order semantics described below.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of ideas per page. If unspecified, at most 10 ideas will be returned. The maximum value is 2000; values above 2000 will be coerced to 2000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Used to fetch next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. If defined, specifies the creator for which to filter by. Format: publishers/{publisher}/properties/{property}",
	//       "location": "path",
	//       "pattern": "^platforms/[^/]+/properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/ideas",
	//   "response": {
	//     "$ref": "GoogleSearchIdeahubV1betaListIdeasResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PlatformsPropertiesIdeasListCall) Pages(ctx context.Context, f func(*GoogleSearchIdeahubV1betaListIdeasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "ideahub.platforms.properties.locales.list":

type PlatformsPropertiesLocalesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns which locales ideas are available in for a given
// Creator.
//
// - parent: The web property to check idea availability for Format:
//   platforms/{platform}/property/{property}.
func (r *PlatformsPropertiesLocalesService) List(parent string) *PlatformsPropertiesLocalesListCall {
	c := &PlatformsPropertiesLocalesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of locales to return. The service may return fewer than this value.
// If unspecified, at most 100 locales will be returned. The maximum
// value is 100; values above 100 will be coerced to 100.
func (c *PlatformsPropertiesLocalesListCall) PageSize(pageSize int64) *PlatformsPropertiesLocalesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAvailableLocales` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAvailableLocales` must match the call that provided
// the page token.
func (c *PlatformsPropertiesLocalesListCall) PageToken(pageToken string) *PlatformsPropertiesLocalesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlatformsPropertiesLocalesListCall) Fields(s ...googleapi.Field) *PlatformsPropertiesLocalesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PlatformsPropertiesLocalesListCall) IfNoneMatch(entityTag string) *PlatformsPropertiesLocalesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlatformsPropertiesLocalesListCall) Context(ctx context.Context) *PlatformsPropertiesLocalesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlatformsPropertiesLocalesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlatformsPropertiesLocalesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/locales")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ideahub.platforms.properties.locales.list" call.
// Exactly one of *GoogleSearchIdeahubV1betaListAvailableLocalesResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleSearchIdeahubV1betaListAvailableLocalesResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PlatformsPropertiesLocalesListCall) Do(opts ...googleapi.CallOption) (*GoogleSearchIdeahubV1betaListAvailableLocalesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleSearchIdeahubV1betaListAvailableLocalesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns which locales ideas are available in for a given Creator.",
	//   "flatPath": "v1beta/platforms/{platformsId}/properties/{propertiesId}/locales",
	//   "httpMethod": "GET",
	//   "id": "ideahub.platforms.properties.locales.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of locales to return. The service may return fewer than this value. If unspecified, at most 100 locales will be returned. The maximum value is 100; values above 100 will be coerced to 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAvailableLocales` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAvailableLocales` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The web property to check idea availability for Format: platforms/{platform}/property/{property}",
	//       "location": "path",
	//       "pattern": "^platforms/[^/]+/properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/locales",
	//   "response": {
	//     "$ref": "GoogleSearchIdeahubV1betaListAvailableLocalesResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PlatformsPropertiesLocalesListCall) Pages(ctx context.Context, f func(*GoogleSearchIdeahubV1betaListAvailableLocalesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "ideahub.platforms.properties.topicStates.patch":

type PlatformsPropertiesTopicStatesPatchCall struct {
	s                                   *Service
	nameid                              string
	googlesearchideahubv1betatopicstate *GoogleSearchIdeahubV1betaTopicState
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Update a topic state resource.
//
// - name: Unique identifier for the topic state. Format:
//   platforms/{platform}/properties/{property}/topicStates/{topic_state}.
func (r *PlatformsPropertiesTopicStatesService) Patch(nameid string, googlesearchideahubv1betatopicstate *GoogleSearchIdeahubV1betaTopicState) *PlatformsPropertiesTopicStatesPatchCall {
	c := &PlatformsPropertiesTopicStatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googlesearchideahubv1betatopicstate = googlesearchideahubv1betatopicstate
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *PlatformsPropertiesTopicStatesPatchCall) UpdateMask(updateMask string) *PlatformsPropertiesTopicStatesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlatformsPropertiesTopicStatesPatchCall) Fields(s ...googleapi.Field) *PlatformsPropertiesTopicStatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlatformsPropertiesTopicStatesPatchCall) Context(ctx context.Context) *PlatformsPropertiesTopicStatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlatformsPropertiesTopicStatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlatformsPropertiesTopicStatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlesearchideahubv1betatopicstate)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ideahub.platforms.properties.topicStates.patch" call.
// Exactly one of *GoogleSearchIdeahubV1betaTopicState or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleSearchIdeahubV1betaTopicState.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PlatformsPropertiesTopicStatesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleSearchIdeahubV1betaTopicState, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleSearchIdeahubV1betaTopicState{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update a topic state resource.",
	//   "flatPath": "v1beta/platforms/{platformsId}/properties/{propertiesId}/topicStates/{topicStatesId}",
	//   "httpMethod": "PATCH",
	//   "id": "ideahub.platforms.properties.topicStates.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Unique identifier for the topic state. Format: platforms/{platform}/properties/{property}/topicStates/{topic_state}",
	//       "location": "path",
	//       "pattern": "^platforms/[^/]+/properties/[^/]+/topicStates/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleSearchIdeahubV1betaTopicState"
	//   },
	//   "response": {
	//     "$ref": "GoogleSearchIdeahubV1betaTopicState"
	//   }
	// }

}
